/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.ArchUnitException;
import java.lang.reflect.Constructor;
import java.util.Arrays;

@Internal
public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T newInstanceOf(Class<T> type, Object ... parameters) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(ReflectionUtils.typesOf(parameters));
            constructor.setAccessible(true);
            return constructor.newInstance(parameters);
        }
        catch (Exception e) {
            throw new ArchUnitException.ReflectionException(e);
        }
    }

    private static Class<?>[] typesOf(Object[] parameters) {
        return (Class[])Arrays.stream(parameters).map(Object::getClass).toArray(Class[]::new);
    }
}

