/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import jogamp.graph.font.typecast.ot.table.CmapFormat;

public class CmapFormat6
extends CmapFormat {
    private final int _length;
    private final int _language;
    private final int _firstCode;
    private final int _entryCount;
    private final int[] _glyphIdArray;

    CmapFormat6(DataInput dataInput) throws IOException {
        this._length = dataInput.readUnsignedShort();
        this._language = dataInput.readUnsignedShort();
        this._firstCode = dataInput.readUnsignedShort();
        this._entryCount = dataInput.readUnsignedShort();
        this._glyphIdArray = new int[this._entryCount];
        for (int i = 0; i < this._entryCount; ++i) {
            this._glyphIdArray[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public int getFormat() {
        return 6;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public int getLanguage() {
        return this._language;
    }

    @Override
    public int getRangeCount() {
        return 1;
    }

    @Override
    public CmapFormat.Range getRange(int n) throws ArrayIndexOutOfBoundsException {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new CmapFormat.Range(this._firstCode, this._entryCount);
    }

    @Override
    public int mapCharCode(int n) {
        if (this._firstCode <= n && n < this._firstCode + this._entryCount) {
            return this._glyphIdArray[n - this._firstCode];
        }
        return 0;
    }

    @Override
    public String toString() {
        return super.toString() + "    format:         " + this.getFormat() + "\n    language:       " + this.getLanguage() + "\n    firstCode:      " + this._firstCode + "\n    entryCount:     " + this._entryCount + "\n    glyphIdArray:   " + Arrays.toString(this._glyphIdArray) + "\n";
    }
}

