/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import db.Transaction;
import ghidra.app.plugin.core.debug.service.emulation.EmulatorOutOfMemoryException;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.database.DBTrace;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathPattern;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.model.target.schema.XmlSchemaContext;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.util.DifferenceAddressSetView;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.JDOMException;

public class ProgramEmulationUtils {
    public static final String EMU_CTX_XML = "<context>\n    <schema name='EmuSession' elementResync='NEVER' attributeResync='NEVER'>\n        <interface name='Process' />\n        <interface name='Aggregate' />\n        <attribute name='Breakpoints' schema='BreakpointContainer' />\n        <attribute name='Memory' schema='RegionContainer' />\n        <attribute name='Modules' schema='ModuleContainer' />\n        <attribute name='Threads' schema='ThreadContainer' />\n    </schema>\n    <schema name='BreakpointContainer' canonical='yes' elementResync='NEVER'\n            attributeResync='NEVER'>\n        <element schema='Breakpoint' />\n    </schema>\n    <schema name='Breakpoint' elementResync='NEVER' attributeResync='NEVER'>\n        <interface name='BreakpointSpec' />\n        <interface name='BreakpointLocation' />\n    </schema>\n    <schema name='RegionContainer' canonical='yes' elementResync='NEVER'\n            attributeResync='NEVER'>\n        <element schema='Region' />\n    </schema>\n    <schema name='Region' elementResync='NEVER' attributeResync='NEVER'>\n        <interface name='MemoryRegion' />\n    </schema>\n    <schema name='ModuleContainer' canonical='yes' elementResync='NEVER'\n            attributeResync='NEVER'>\n        <element schema='Module' />\n    </schema>\n    <schema name='Module' elementResync='NEVER' attributeResync='NEVER'>\n        <interface name='Module' />\n        <attribute name='Sections' schema='SectionContainer' />\n    </schema>\n    <schema name='SectionContainer' canonical='yes' elementResync='NEVER'\n            attributeResync='NEVER'>\n        <element schema='Section' />\n    </schema>\n    <schema name='Section' elementResync='NEVER' attributeResync='NEVER'>\n        <interface name='Section' />\n    </schema>\n    <schema name='ThreadContainer' canonical='yes' elementResync='NEVER'\n            attributeResync='NEVER'>\n        <element schema='Thread' />\n    </schema>\n    <schema name='Thread' elementResync='NEVER' attributeResync='NEVER'>\n        <interface name='Thread' />\n        <interface name='Activatable' />\n        <interface name='Aggregate' />\n        <attribute name='Stack' schema='Stack' />\n        <attribute name='Registers' schema='RegisterContainer' />\n    </schema>\n    <schema name='Stack' canonical='yes'>\n        <interface name='Stack' />\n        <element schema='Frame' />\n    </schema>\n    <schema name='Frame'>\n        <interface name='StackFrame' />\n    </schema>\n    <schema name='RegisterContainer' canonical='yes' elementResync='NEVER'\n            attributeResync='NEVER'>\n        <interface name='RegisterContainer' />\n        <element schema='Register' />\n    </schema>\n    <schema name='Register' elementResync='NEVER' attributeResync='NEVER'>\n        <interface name='Register' />\n    </schema>\n</context>\n";
    public static final SchemaContext EMU_CTX;
    public static final TraceObjectSchema EMU_SESSION_SCHEMA;
    public static final String BLOCK_NAME_STACK = "STACK";
    public static final String EMULATION_STARTED_AT = "Emulation started at ";

    private ProgramEmulationUtils() {
    }

    public static String getTraceName(Program program) {
        DomainFile df = program.getDomainFile();
        if (df != null) {
            return "Emulate " + df.getName();
        }
        return "Emulate " + program.getName();
    }

    public static String getModuleName(Program program) {
        String executablePath = program.getExecutablePath();
        if (executablePath != null) {
            return executablePath;
        }
        DomainFile df = program.getDomainFile();
        if (df != null) {
            return df.getName();
        }
        return program.getName();
    }

    public static Set<TraceMemoryFlag> getRegionFlags(MemoryBlock block) {
        EnumSet<TraceMemoryFlag> result = EnumSet.noneOf(TraceMemoryFlag.class);
        int mask = block.getFlags();
        if ((mask & 4) != 0) {
            result.add(TraceMemoryFlag.READ);
        }
        if ((mask & 2) != 0) {
            result.add(TraceMemoryFlag.WRITE);
        }
        if ((mask & 1) != 0) {
            result.add(TraceMemoryFlag.EXECUTE);
        }
        if ((mask & 8) != 0) {
            result.add(TraceMemoryFlag.VOLATILE);
        }
        return result;
    }

    public static void loadExecutable(TraceSnapshot snapshot, Program program, List<AddressSpace> activeOverlays) {
        Trace trace = snapshot.getTrace();
        PathPattern patRegion = ProgramEmulationUtils.computePatternRegion(trace);
        HashMap<AddressSpace, DebuggerStaticMappingUtils.Extrema> extremaBySpace = new HashMap<AddressSpace, DebuggerStaticMappingUtils.Extrema>();
        Lifespan nowOn = Lifespan.nowOn((long)snapshot.getKey());
        try {
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!DebuggerStaticMappingUtils.isReal(block)) continue;
                AddressRangeImpl range = new AddressRangeImpl(block.getStart(), block.getEnd());
                extremaBySpace.computeIfAbsent(range.getAddressSpace(), s -> new DebuggerStaticMappingUtils.Extrema()).consider((AddressRange)range);
                String modName = ProgramEmulationUtils.getModuleName(program);
                String path = patRegion.applyKeys(new String[]{String.valueOf(block.getStart()) + "-" + modName + ":" + block.getName()}).getSingletonPath().toString();
                trace.getMemoryManager().createRegion(path, snapshot.getKey(), (AddressRange)range, ProgramEmulationUtils.getRegionFlags(block));
            }
            AddressSet identical = new AddressSet();
            for (DebuggerStaticMappingUtils.Extrema extrema : extremaBySpace.values()) {
                identical.add(extrema.getMin(), extrema.getMax());
            }
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!block.isOverlay() || !activeOverlays.contains(block.getStart().getAddressSpace())) continue;
                Address phys = block.getStart().getPhysicalAddress();
                DebuggerStaticMappingUtils.addMapping((TraceLocation)new DefaultTraceLocation(trace, null, nowOn, phys), new ProgramLocation(program, block.getStart()), block.getSize(), false);
                identical.delete(phys, block.getEnd().getPhysicalAddress());
            }
            for (AddressRange range : identical) {
                DebuggerStaticMappingUtils.addMapping((TraceLocation)new DefaultTraceLocation(trace, null, nowOn, range.getMinAddress()), new ProgramLocation(program, range.getMinAddress()), range.getLength(), false);
            }
        }
        catch (TraceOverlappedRegionException | TraceConflictedMappingException | DuplicateNameException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PathPattern computePattern(TraceObjectSchema root, Trace trace, Class<? extends TraceObjectInterface> iface) {
        PathFilter filter = root.searchFor(iface, true);
        PathPattern pattern = filter.getSingletonPattern();
        if (pattern == null || pattern.countWildcards() != 1) {
            throw new IllegalArgumentException("Cannot find unique " + iface.getSimpleName() + " container");
        }
        return pattern;
    }

    public static PathPattern computePatternRegion(Trace trace) {
        TraceObjectSchema root = trace.getObjectManager().getRootSchema();
        if (root == null) {
            return PathFilter.parse((String)"Memory[]");
        }
        return ProgramEmulationUtils.computePattern(root, trace, TraceObjectMemoryRegion.class);
    }

    public static PathPattern computePatternThread(Trace trace) {
        TraceObjectSchema root = trace.getObjectManager().getRootSchema();
        if (root == null) {
            return PathFilter.parse((String)"Threads[]");
        }
        return ProgramEmulationUtils.computePattern(root, trace, TraceObjectThread.class);
    }

    public static TraceThread spawnThread(Trace trace, long snap) {
        String path;
        TraceThreadManager tm = trace.getThreadManager();
        PathPattern patThread = ProgramEmulationUtils.computePatternThread(trace);
        long next = tm.getAllThreads().size();
        while (!tm.getThreadsByPath(path = patThread.applyKeys(new String[]{Long.toString(next)}).getSingletonPath().toString()).isEmpty()) {
            ++next;
        }
        try {
            return tm.createThread(path, KeyPath.makeIndex((long)next), snap);
        }
        catch (DuplicateNameException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void initializeRegisters(Trace trace, long snap, TraceThread thread, Program program, Address tracePc, Address programPc, AddressRange stack) {
        Register regPC;
        TraceMemoryManager memory = trace.getMemoryManager();
        if (thread instanceof TraceObjectThread) {
            TraceObjectThread ot = (TraceObjectThread)thread;
            TraceObject object = ot.getObject();
            PathFilter regsFilter = object.getRoot().getSchema().searchForRegisterContainer(0, object.getCanonicalPath());
            if (regsFilter.isNone()) {
                throw new IllegalArgumentException("Cannot create register container");
            }
            Iterator iterator = regsFilter.getPatterns().iterator();
            if (iterator.hasNext()) {
                PathPattern regsPattern = (PathPattern)iterator.next();
                trace.getObjectManager().createObject(regsPattern.getSingletonPath());
            }
        }
        TraceMemorySpace regSpace = memory.getMemoryRegisterSpace(thread, true);
        if (program != null) {
            ProgramContext ctx = program.getProgramContext();
            for (Register reg : Stream.of(ctx.getRegistersWithValues()).map(Register::getBaseRegister).collect(Collectors.toSet())) {
                RegisterValue rv = ctx.getRegisterValue(reg, programPc);
                if (rv == null || !rv.hasAnyValue()) continue;
                TraceMemorySpace space = reg.getAddressSpace().isRegisterSpace() ? regSpace : memory;
                space.setValue(snap, new RegisterValue(reg, BigInteger.ZERO).combineValues(rv));
            }
        }
        TraceMemorySpace spacePC = (regPC = trace.getBaseLanguage().getProgramCounter()).getAddressSpace().isRegisterSpace() ? regSpace : memory;
        spacePC.setValue(snap, new RegisterValue(regPC, NumericUtilities.unsignedLongToBigInteger((long)tracePc.getAddressableWordOffset())));
        if (stack != null) {
            CompilerSpec cSpec = trace.getBaseCompilerSpec();
            Address sp = cSpec.stackGrowsNegative() ? stack.getMaxAddress().addWrap(1L) : stack.getMinAddress();
            Register regSP = cSpec.getStackPointer();
            if (regSP != null) {
                TraceMemorySpace spaceSP = regSP.getAddressSpace().isRegisterSpace() ? regSpace : memory;
                spaceSP.setValue(snap, new RegisterValue(regSP, NumericUtilities.unsignedLongToBigInteger((long)sp.getAddressableWordOffset())));
            }
        }
    }

    public static AddressRange allocateStackCustomByContext(Trace trace, long snap, TraceThread thread, Program program, long size, Address programPc) {
        AddressRangeImpl alloc;
        CompilerSpec cSpec;
        Register sp;
        if (program == null) {
            return null;
        }
        ProgramContext ctx = program.getProgramContext();
        RegisterValue spVal = ctx.getRegisterValue(sp = (cSpec = trace.getBaseCompilerSpec()).getStackPointer(), programPc);
        if (spVal == null || !spVal.hasValue()) {
            return null;
        }
        Address spAddr = cSpec.getStackBaseSpace().getAddress(spVal.getUnsignedValue().longValue());
        if (cSpec.stackGrowsNegative()) {
            Address max = spAddr.subtractWrap(1L);
            Address min = spAddr.subtractWrapSpace(size);
            alloc = min.compareTo((Object)max) > 0 ? new AddressRangeImpl(max.getAddressSpace().getMinAddress(), max) : new AddressRangeImpl(min, max);
        } else {
            Address min = spAddr;
            Address max = spAddr.addWrap(size - 1L);
            alloc = min.compareTo((Object)max) > 0 ? new AddressRangeImpl(min, min.getAddressSpace().getMaxAddress()) : new AddressRangeImpl(min, max);
        }
        PathPattern patRegion = ProgramEmulationUtils.computePatternRegion(trace);
        String threadName = KeyPath.parseIfIndex((String)thread.getName(snap));
        String path = patRegion.applyKeys(new String[]{String.valueOf(alloc.getMinAddress()) + "-stack " + threadName}).getSingletonPath().toString();
        TraceMemoryManager mm = trace.getMemoryManager();
        try {
            return mm.createRegion(path, snap, (AddressRange)alloc, new TraceMemoryFlag[]{TraceMemoryFlag.READ, TraceMemoryFlag.WRITE}).getRange(snap);
        }
        catch (TraceOverlappedRegionException e) {
            Msg.showError(ProgramEmulationUtils.class, null, (String)"Stack conflict", (Object)"The stack region %s conflicts with another: %s. You may need to initialize the stack pointer manually.".formatted(alloc, e.getConflicts().iterator().next()));
            return alloc;
        }
        catch (DuplicateNameException e) {
            Msg.showError(ProgramEmulationUtils.class, null, (String)"Stack conflict", (Object)"A region already exists with the same name: %s. You may need to initialize the stack pointer manually.".formatted(path));
            return alloc;
        }
    }

    public static AddressRange allocateStackCustomByBlock(Trace trace, long snap, TraceThread thread, Program program) {
        if (program == null) {
            return null;
        }
        AddressSpace space = trace.getBaseCompilerSpec().getStackBaseSpace();
        MemoryBlock stackBlock = program.getMemory().getBlock(BLOCK_NAME_STACK);
        if (stackBlock == null) {
            return null;
        }
        if (space != stackBlock.getStart().getAddressSpace().getPhysicalSpace()) {
            Msg.showError(ProgramEmulationUtils.class, null, (String)"Invalid STACK block", (Object)"The STACK block must be in the stack's base space. Ignoring.");
            return null;
        }
        AddressRangeImpl alloc = new AddressRangeImpl(stackBlock.getStart().getPhysicalAddress(), stackBlock.getEnd().getPhysicalAddress());
        if (stackBlock.isOverlay() || DebuggerStaticMappingUtils.isReal(stackBlock)) {
            return alloc;
        }
        PathPattern patRegion = ProgramEmulationUtils.computePatternRegion(trace);
        String path = patRegion.applyKeys(new String[]{String.valueOf(stackBlock.getStart()) + "-STACK"}).getSingletonPath().toString();
        TraceMemoryManager mm = trace.getMemoryManager();
        try {
            return mm.createRegion(path, snap, (AddressRange)alloc, new TraceMemoryFlag[]{TraceMemoryFlag.READ, TraceMemoryFlag.WRITE}).getRange(snap);
        }
        catch (TraceOverlappedRegionException e) {
            Msg.showError(ProgramEmulationUtils.class, null, (String)"Stack conflict", (Object)"The STACK region %s conflicts with another: %s. You may need to initialize the stack pointer manually.".formatted(alloc, e.getConflicts().iterator().next()));
            return alloc;
        }
        catch (DuplicateNameException e) {
            Msg.showError(ProgramEmulationUtils.class, null, (String)"Stack conflict", (Object)"A region already exists with the same name: %s. You may need to initialize the stack pointer manually.".formatted(path));
            return alloc;
        }
    }

    public static AddressRange allocateStack(Trace trace, long snap, TraceThread thread, Program program, long size, Address programPc) {
        AddressRange customByContext = ProgramEmulationUtils.allocateStackCustomByContext(trace, snap, thread, program, size, programPc);
        if (customByContext != null) {
            return customByContext;
        }
        AddressRange customByBlock = ProgramEmulationUtils.allocateStackCustomByBlock(trace, snap, thread, program);
        if (customByBlock != null) {
            return customByBlock;
        }
        AddressSpace space = trace.getBaseCompilerSpec().getStackBaseSpace();
        Address max = space.getMaxAddress();
        AddressSet eligible = max.getOffsetAsBigInteger().compareTo(BigInteger.valueOf(4096L)) < 0 ? new AddressSet(space.getMinAddress(), max) : new AddressSet(space.getAddress(4096L), max);
        TraceMemoryManager mm = trace.getMemoryManager();
        DifferenceAddressSetView left = new DifferenceAddressSetView((AddressSetView)eligible, mm.getRegionsAddressSet(snap));
        PathPattern patRegion = ProgramEmulationUtils.computePatternRegion(trace);
        try {
            for (AddressRange candidate : left) {
                if (Long.compareUnsigned(candidate.getLength(), size) < 0) continue;
                AddressRangeImpl alloc = new AddressRangeImpl(candidate.getMinAddress(), size);
                String threadName = KeyPath.parseIfIndex((String)thread.getName(snap));
                String path = patRegion.applyKeys(new String[]{String.valueOf(alloc.getMinAddress()) + "-stack " + threadName}).getSingletonPath().toString();
                return mm.createRegion(path, snap, (AddressRange)alloc, new TraceMemoryFlag[]{TraceMemoryFlag.READ, TraceMemoryFlag.WRITE}).getRange(snap);
            }
        }
        catch (AddressOverflowException | TraceOverlappedRegionException | DuplicateNameException e) {
            throw new AssertionError((Object)e);
        }
        throw new EmulatorOutOfMemoryException();
    }

    protected static void createObjects(Trace trace) {
        TraceObjectManager om = trace.getObjectManager();
        om.createRootObject(EMU_SESSION_SCHEMA);
        om.createObject(KeyPath.parse((String)"Breakpoints")).insert((Lifespan)Lifespan.ALL, TraceObject.ConflictResolution.DENY);
        om.createObject(KeyPath.parse((String)"Memory")).insert((Lifespan)Lifespan.ALL, TraceObject.ConflictResolution.DENY);
        om.createObject(KeyPath.parse((String)"Modules")).insert((Lifespan)Lifespan.ALL, TraceObject.ConflictResolution.DENY);
        om.createObject(KeyPath.parse((String)"Threads")).insert((Lifespan)Lifespan.ALL, TraceObject.ConflictResolution.DENY);
    }

    public static Trace launchEmulationTrace(Program program, Address pc, Object consumer) throws IOException {
        DBTrace trace = null;
        boolean success = false;
        try {
            trace = new DBTrace(ProgramEmulationUtils.getTraceName(program), program.getCompilerSpec(), consumer);
            try (Transaction tx = trace.openTransaction("Emulate");){
                ProgramEmulationUtils.createObjects((Trace)trace);
                TraceSnapshot initial = trace.getTimeManager().createSnapshot(EMULATION_STARTED_AT + String.valueOf(pc));
                long snap = initial.getKey();
                List<AddressSpace> overlays = pc.getAddressSpace().isOverlaySpace() ? List.of(pc.getAddressSpace()) : List.of();
                ProgramEmulationUtils.loadExecutable(initial, program, overlays);
                TraceThread thread = ProgramEmulationUtils.doLaunchEmulationThread((Trace)trace, snap, program, pc, pc);
                initial.setEventThread(thread);
            }
            trace.clearUndo();
            success = true;
            tx = trace;
            return tx;
        }
        catch (LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            if (!success && trace != null) {
                trace.release(consumer);
            }
        }
    }

    public static TraceThread doLaunchEmulationThread(Trace trace, long snap, Program program, Address tracePc, Address programPc) {
        AddressRange stack;
        TraceThread thread = ProgramEmulationUtils.spawnThread(trace, snap);
        try {
            stack = ProgramEmulationUtils.allocateStack(trace, snap, thread, program, 16384L, programPc);
        }
        catch (EmulatorOutOfMemoryException e) {
            Msg.warn(ProgramEmulationUtils.class, (Object)"Cannot allocate a stack. Please initialize manually.");
            stack = null;
        }
        ProgramEmulationUtils.initializeRegisters(trace, snap, thread, program, tracePc, programPc, stack);
        return thread;
    }

    public static TraceThread launchEmulationThread(Trace trace, long snap, Program program, Address tracePc, Address programPc) {
        try (Transaction tx = trace.openTransaction("Emulate new Thread");){
            TraceThread thread;
            TraceThread traceThread = thread = ProgramEmulationUtils.doLaunchEmulationThread(trace, snap, program, tracePc, programPc);
            return traceThread;
        }
    }

    public static boolean isEmulatedProgram(Trace trace) {
        TraceSnapshot snapshot = trace.getTimeManager().getSnapshot(0L, false);
        if (snapshot == null) {
            return false;
        }
        return snapshot.getDescription().startsWith(EMULATION_STARTED_AT);
    }

    static {
        try {
            EMU_CTX = XmlSchemaContext.deserialize((String)EMU_CTX_XML);
        }
        catch (JDOMException e) {
            throw new AssertionError((Object)e);
        }
        EMU_SESSION_SCHEMA = EMU_CTX.getSchema(new TraceObjectSchema.SchemaName("EmuSession"));
    }
}

