/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.variadic;

import ghidra.app.plugin.core.string.variadic.FormatArgument;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.LongLongDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedLongLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FormatStringParser {
    public static final String INTMAX_T_NAME = "intmax_t";
    public static final String UINTMAX_T_NAME = "uintmax_t";
    public static final String SIZE_T_NAME = "size_t";
    public static final String PTRDIFF_T_NAME = "ptrdiff_t";
    private DataTypeManager dataTypeManager;
    private TypeDef intmax_t;
    private TypeDef uintmax_t;
    private TypeDef size_t;
    private TypeDef ptrdiff_t;

    public FormatStringParser(Program program) {
        this.dataTypeManager = program.getDataTypeManager();
    }

    private List<String> parseFormatString(String formatString) {
        ArrayList<String> formatArgumentList = new ArrayList<String>();
        Object current = "";
        for (int i = 0; i < formatString.length(); ++i) {
            char c = formatString.charAt(i);
            if (c != '%') continue;
            if (this.emitPercent(formatString, i)) {
                ++i;
                continue;
            }
            c = formatString.charAt(++i);
            while (!this.isConversionSpecifier(c)) {
                current = (String)current + c;
                if (++i >= formatString.length()) {
                    return null;
                }
                c = formatString.charAt(i);
            }
            formatArgumentList.add((String)current + c);
            current = "";
        }
        return formatArgumentList;
    }

    private boolean convertToFormatArguments(String formatString, List<FormatArgument> formatArgumentList, boolean isOutputType) {
        FormatParsingData data = new FormatParsingData(this);
        for (int i = 0; i < formatString.length(); ++i) {
            char c = formatString.charAt(i);
            if ((i = this.preprocessChar(formatString, i, isOutputType)) == -1) {
                return false;
            }
            if (this.isFlag(c)) continue;
            if (data.getLengthModifier() != null) {
                return this.addArgumentWithModifier(c, data, formatArgumentList);
            }
            data.setLengthModifier(this.detectLengthModifier(c));
            if (data.getLengthModifier() == null) {
                data.setConversionSpecifier(this.detectConversionSpecifier(c));
                if (data.getConversionSpecifier() != null) {
                    if (!this.verifyConversionPair(data.getLengthModifier(), data.getConversionSpecifier())) {
                        return false;
                    }
                    formatArgumentList.add(new FormatArgument(data.getLengthModifier(), data.getConversionSpecifier()));
                    return true;
                }
                if (data.isPrecisionComplete()) {
                    return false;
                }
                if (!Character.isDigit(c) && c != '.' && c != '*') {
                    return false;
                }
                if (!(isOutputType ? (i = this.handleOutputConversionArgument(formatString, i, data, formatArgumentList)) == -1 : (i = this.handleInputConversionArgument(formatString, i, data, formatArgumentList)) == -1)) continue;
                return false;
            }
            if (i + 1 >= formatString.length()) continue;
            i = this.initiateLengthModifierExtension(formatString, i, data);
        }
        return true;
    }

    private int preprocessChar(String formatString, int i, boolean isOutputType) {
        char c = formatString.charAt(i);
        if (c == '$') {
            return -1;
        }
        if (this.isFlag(c)) {
            if (!isOutputType) {
                return -1;
            }
            i = this.skipFlags(formatString, i);
        }
        return i;
    }

    private int initiateLengthModifierExtension(String formatString, int i, FormatParsingData data) {
        String tmpLengthModifier = this.extendLengthModifier(data.getLengthModifier(), formatString.charAt(i + 1));
        if (tmpLengthModifier != null) {
            ++i;
            data.setLengthModifier(tmpLengthModifier);
        }
        return i;
    }

    private boolean addArgumentWithModifier(char c, FormatParsingData data, List<FormatArgument> formatArgumentList) {
        data.setConversionSpecifier(this.detectConversionSpecifier(c));
        if (data.getConversionSpecifier() == null || !this.verifyConversionPair(data.getLengthModifier(), data.getConversionSpecifier())) {
            return false;
        }
        formatArgumentList.add(new FormatArgument(data.getLengthModifier(), data.getConversionSpecifier()));
        return true;
    }

    private int handleOutputConversionArgument(String formatString, int i, FormatParsingData data, List<FormatArgument> formatArgumentList) {
        char c = formatString.charAt(i);
        if (!data.isPrecisionComplete() && !data.isFieldWidthComplete() && c != '.') {
            if (c == '*') {
                formatArgumentList.add(new FormatArgument(null, "*"));
            } else {
                i = this.skipIntegers(formatString, i);
            }
            if (i == -1) {
                return i;
            }
            data.setFieldWidthComplete(true);
        } else {
            if (data.isFieldWidthComplete() && c != '.') {
                return -1;
            }
            if (!data.isPrecisionComplete() && c == '.') {
                if (i + 1 < formatString.length() && formatString.charAt(i + 1) == '*') {
                    ++i;
                    formatArgumentList.add(new FormatArgument(null, "*"));
                } else {
                    i = this.skipIntegers(formatString, i + 1);
                }
                if (i == -1) {
                    return i;
                }
                data.setPrecisionComplete(true);
            } else {
                return -1;
            }
        }
        return i;
    }

    private int handleInputConversionArgument(String formatString, int i, FormatParsingData data, List<FormatArgument> formatArgumentList) {
        char c = formatString.charAt(i);
        if (c == '*') {
            formatArgumentList.add(new FormatArgument(null, "*"));
        } else if (Character.isDigit(c)) {
            if ((i = this.skipIntegers(formatString, i + 1)) == -1) {
                return i;
            }
            data.setPrecisionComplete(true);
        } else {
            return -1;
        }
        return i;
    }

    public List<FormatArgument> convertToFormatArgumentList(String formatString, boolean isOutputType) {
        if (formatString == null) {
            return null;
        }
        List<String> formatStrArgumentList = this.parseFormatString(formatString);
        if (formatStrArgumentList == null) {
            return null;
        }
        ArrayList<FormatArgument> formatArgumentList = new ArrayList<FormatArgument>();
        for (String formatStrArgument : formatStrArgumentList) {
            boolean status = this.convertToFormatArguments(formatStrArgument, formatArgumentList, isOutputType);
            if (status) continue;
            if (formatStrArgumentList.stream().filter(str -> str.contains("$")).findAny().isPresent()) {
                return this.analyzeFormatStringWithParameters(formatString);
            }
            return null;
        }
        return formatArgumentList.contains(null) ? null : formatArgumentList;
    }

    public List<FormatArgument> analyzeFormatStringWithParameters(String formatString) {
        FormatParsingData data = new FormatParsingData(this);
        HashMap<Integer, FormatArgument> formatArgumentMap = new HashMap<Integer, FormatArgument>();
        for (int i = 0; i < formatString.length(); ++i) {
            char c = formatString.charAt(i);
            if (c == ' ') continue;
            if (c == '%') {
                if (this.emitPercent(formatString, i)) {
                    ++i;
                } else {
                    data.setInConversion(true);
                    data.clearData();
                    data.setParameterIndex(this.locateParameterIndex(formatString, i));
                    if (data.getParameterIndex() == 0) {
                        return null;
                    }
                    if (!this.isFlag(formatString.charAt((i += Integer.toString(data.getParameterIndex()).length() + 1) + 1))) continue;
                    i = this.skipFlags(formatString, i + 1);
                    continue;
                }
            }
            if (!data.isInConversion()) continue;
            if (data.getLengthModifier() != null) {
                data.setConversionSpecifier(this.detectConversionSpecifier(c));
                if (data.getConversionSpecifier() == null) {
                    return null;
                }
                formatArgumentMap.put(data.getParameterIndex(), new FormatArgument(data.getLengthModifier(), data.getConversionSpecifier()));
                data.setInConversion(false);
                continue;
            }
            data.setLengthModifier(this.detectLengthModifier(c));
            if (data.getLengthModifier() != null || (i = this.searchWithNullModifier(formatString, i, data, formatArgumentMap)) != -1) continue;
            return null;
        }
        return this.convertMapToList(formatArgumentMap);
    }

    private int searchWithNullModifier(String formatString, int i, FormatParsingData data, Map<Integer, FormatArgument> formatArgumentMap) {
        char c = formatString.charAt(i);
        data.setConversionSpecifier(this.detectConversionSpecifier(c));
        if (data.getConversionSpecifier() != null) {
            formatArgumentMap.put(data.getParameterIndex(), new FormatArgument(data.getLengthModifier(), data.getConversionSpecifier()));
            data.setInConversion(false);
        } else {
            if (data.isPrecisionComplete()) {
                return -1;
            }
            if (!Character.isDigit(c) && c != '.' && c != '*') {
                return -1;
            }
            if (!data.isPrecisionComplete() && !data.isFieldWidthComplete() && c != '.') {
                if ((i = this.handleOutputConversionForParameters(formatString, i, data, formatArgumentMap)) == -1) {
                    return -1;
                }
            } else {
                if (data.isFieldWidthComplete() && c != '.') {
                    return -1;
                }
                if (!data.isPrecisionComplete() && c == '.') {
                    if ((i = this.handlePrecisionForParameters(formatString, i, data, formatArgumentMap)) == -1) {
                        return -1;
                    }
                } else {
                    return -1;
                }
            }
        }
        return i;
    }

    private int handlePrecisionForParameters(String formatString, int i, FormatParsingData data, Map<Integer, FormatArgument> formatArgumentMap) {
        if (i + 1 < formatString.length() && formatString.charAt(i + 1) == '*') {
            int precisionIdx;
            if ((precisionIdx = this.locateParameterIndex(formatString, ++i)) == 0) {
                return -1;
            }
            i += Integer.toString(precisionIdx).length() + 1;
            formatArgumentMap.put(precisionIdx, new FormatArgument(null, "d"));
        } else if ((i = this.skipIntegers(formatString, i + 1)) == -1) {
            return -1;
        }
        data.setPrecisionComplete(true);
        return i;
    }

    private int handleOutputConversionForParameters(String formatString, int i, FormatParsingData data, Map<Integer, FormatArgument> formatArgumentMap) {
        char c = formatString.charAt(i);
        if (c == '*') {
            int fieldWidthIdx = this.locateParameterIndex(formatString, i);
            if (fieldWidthIdx == 0) {
                return i;
            }
            i += Integer.toString(fieldWidthIdx).length() + 1;
            formatArgumentMap.put(fieldWidthIdx, new FormatArgument(null, "d"));
        } else if ((i = this.skipIntegers(formatString, i)) == -1) {
            return i;
        }
        data.setFieldWidthComplete(true);
        return i;
    }

    private List<FormatArgument> convertMapToList(Map<Integer, FormatArgument> formatArgumentMap) {
        ArrayList<FormatArgument> formatArgumentList = new ArrayList<FormatArgument>();
        for (int i = 1; i <= formatArgumentMap.size(); ++i) {
            FormatArgument formatArgument = formatArgumentMap.get(i);
            if (formatArgument == null) {
                return null;
            }
            formatArgumentList.add(formatArgument);
        }
        return formatArgumentList;
    }

    private int locateParameterIndex(String formatString, int i) {
        char c = formatString.charAt(i);
        if (c != '%' && c != '*') {
            return 0;
        }
        c = formatString.charAt(++i);
        Object paramIndexString = "";
        while (Character.isDigit(c)) {
            paramIndexString = (String)paramIndexString + Character.toString(c);
            c = formatString.charAt(++i);
        }
        return c != '$' || ((String)paramIndexString).length() == 0 || Integer.parseInt((String)paramIndexString) == 0 ? 0 : Integer.parseInt((String)paramIndexString);
    }

    private int skipFlags(String formatString, int i) {
        while (this.isFlag(formatString.charAt(i))) {
            ++i;
        }
        return i - 1;
    }

    private int skipIntegers(String formatString, int i) {
        char c = formatString.charAt(i);
        if (!Character.isDigit(c)) {
            if (this.isLengthModifier(c) || this.isConversionSpecifier(c)) {
                return i - 1;
            }
            return -1;
        }
        while (Character.isDigit(formatString.charAt(i))) {
            ++i;
        }
        return i - 1;
    }

    private boolean emitPercent(String formatString, int i) {
        return formatString.charAt(i) == '%' && i + 1 < formatString.length() && formatString.charAt(i + 1) == '%';
    }

    public DataType[] convertToOutputDataTypes(List<FormatArgument> formatArguments) {
        if (formatArguments == null) {
            return null;
        }
        List dataTypeList = formatArguments.stream().map(argument -> {
            String conversionSpecifier = argument.getConversionSpecifier();
            DataType dt = this.convertPairToDataType(argument.getLengthModifier(), conversionSpecifier.equals("*") ? "d" : conversionSpecifier);
            return dt;
        }).collect(Collectors.toList());
        return dataTypeList.contains(null) ? null : (DataType[])dataTypeList.toArray(DataType[]::new);
    }

    public DataType[] convertToInputDataTypes(List<FormatArgument> formatArguments) {
        if (formatArguments == null) {
            return null;
        }
        ArrayList<Object> dataTypesList = new ArrayList<Object>();
        for (int i = 0; i < formatArguments.size(); ++i) {
            FormatArgument argument = formatArguments.get(i);
            if (argument.getConversionSpecifier().equals("*")) {
                if (formatArguments.get(i + 1).getConversionSpecifier().equals("*")) {
                    return null;
                }
                ++i;
                continue;
            }
            DataType dt = this.convertPairToDataType(argument.getLengthModifier(), argument.getConversionSpecifier());
            if (dt == null) {
                return null;
            }
            if (!(dt instanceof PointerDataType) || this.isVoidPointer(argument.getConversionSpecifier())) {
                dataTypesList.add(this.dataTypeManager.getPointer(dt));
                continue;
            }
            dataTypesList.add(dt);
        }
        return (DataType[])dataTypesList.stream().toArray(DataType[]::new);
    }

    private boolean verifyConversionPair(String lengthModifier, String conversionSpecifier) {
        if (lengthModifier == null || lengthModifier.equals("l")) {
            return true;
        }
        return lengthModifier.equals("L") && this.isDouble(conversionSpecifier) || !lengthModifier.equals("L") && (this.isInteger(conversionSpecifier) || this.isIntegerPointer(conversionSpecifier));
    }

    private DataType convertPairToDataType(String lengthModifier, String conversionSpecifier) {
        if (lengthModifier == null || conversionSpecifier.equals("c") || conversionSpecifier.equals("s") || conversionSpecifier.equals("C") || conversionSpecifier.equals("S")) {
            return this.conversionSpecifierToDataType(conversionSpecifier);
        }
        switch (lengthModifier) {
            case "h": {
                return this.shortLengthModification(conversionSpecifier);
            }
            case "hh": {
                return this.charLengthModification(conversionSpecifier);
            }
            case "l": {
                return this.longLengthModification(conversionSpecifier);
            }
            case "ll": 
            case "q": {
                return this.longLongLengthModification(conversionSpecifier);
            }
            case "j": {
                return this.intmax_t_LengthModification(conversionSpecifier);
            }
            case "z": {
                return this.size_t_LengthModification(conversionSpecifier);
            }
            case "t": {
                return this.ptrdiff_t_LengthModification(conversionSpecifier);
            }
            case "L": {
                return this.longDoubleLengthModification(conversionSpecifier);
            }
        }
        return null;
    }

    private DataType conversionSpecifierToDataType(String conversionSpecifier) {
        switch (conversionSpecifier.charAt(0)) {
            case 'd': 
            case 'i': {
                return new IntegerDataType(this.dataTypeManager);
            }
            case 'X': 
            case 'o': 
            case 'u': 
            case 'x': {
                return new UnsignedIntegerDataType(this.dataTypeManager);
            }
            case 'p': {
                return this.dataTypeManager.getPointer(DataType.VOID);
            }
            case 's': {
                return this.dataTypeManager.getPointer((DataType)new CharDataType(this.dataTypeManager));
            }
            case 'n': {
                return this.dataTypeManager.getPointer((DataType)new IntegerDataType(this.dataTypeManager));
            }
            case 'c': {
                return new UnsignedCharDataType(this.dataTypeManager);
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                return new DoubleDataType(this.dataTypeManager);
            }
            case 'C': 
            case 'S': {
                return this.dataTypeManager.getPointer((DataType)new WideCharDataType(this.dataTypeManager));
            }
        }
        return null;
    }

    private DataType longLengthModification(String conversionSpecifier) {
        if (this.isIntegerPointer(conversionSpecifier)) {
            return this.dataTypeManager.getPointer((DataType)new LongDataType(this.dataTypeManager));
        }
        if (conversionSpecifier.contentEquals("s") || conversionSpecifier.contentEquals("c")) {
            return this.dataTypeManager.getPointer((DataType)new WideCharDataType(this.dataTypeManager));
        }
        return this.isSignedInteger(conversionSpecifier) ? new LongDataType(this.dataTypeManager) : new UnsignedLongDataType(this.dataTypeManager);
    }

    private DataType longLongLengthModification(String conversionSpecifier) {
        if (this.isIntegerPointer(conversionSpecifier)) {
            return this.dataTypeManager.getPointer((DataType)new LongLongDataType(this.dataTypeManager));
        }
        return this.isSignedInteger(conversionSpecifier) ? new LongLongDataType(this.dataTypeManager) : new UnsignedLongLongDataType(this.dataTypeManager);
    }

    private DataType shortLengthModification(String conversionSpecifier) {
        if (this.isIntegerPointer(conversionSpecifier)) {
            return this.dataTypeManager.getPointer((DataType)new ShortDataType(this.dataTypeManager));
        }
        return this.isSignedInteger(conversionSpecifier) ? new ShortDataType(this.dataTypeManager) : new UnsignedShortDataType(this.dataTypeManager);
    }

    private DataType charLengthModification(String conversionSpecifier) {
        if (this.isIntegerPointer(conversionSpecifier)) {
            return this.dataTypeManager.getPointer((DataType)new CharDataType(this.dataTypeManager));
        }
        return this.isSignedInteger(conversionSpecifier) ? new CharDataType(this.dataTypeManager) : new UnsignedCharDataType(this.dataTypeManager);
    }

    private TypeDef lookupTypeDef(String name) {
        ArrayList typeList = new ArrayList();
        this.dataTypeManager.findDataTypes(name, typeList);
        for (DataType dt : typeList) {
            TypeDef td;
            if (!(dt instanceof TypeDef) || !((td = (TypeDef)dt).getBaseDataType() instanceof AbstractIntegerDataType)) continue;
            return td;
        }
        return null;
    }

    private TypeDef getIntMaxT() {
        if (this.intmax_t != null) {
            return this.intmax_t;
        }
        this.intmax_t = this.lookupTypeDef(INTMAX_T_NAME);
        if (this.intmax_t == null) {
            this.intmax_t = new TypedefDataType(INTMAX_T_NAME, (DataType)new LongLongDataType(this.dataTypeManager));
            Msg.warn((Object)this, (Object)("intmax_t not defined.  Generated as `" + String.valueOf(this.intmax_t) + "'"));
        }
        return this.intmax_t;
    }

    private TypeDef getUIntMaxT() {
        if (this.uintmax_t != null) {
            return this.uintmax_t;
        }
        this.uintmax_t = this.lookupTypeDef(UINTMAX_T_NAME);
        if (this.uintmax_t == null) {
            this.uintmax_t = new TypedefDataType(UINTMAX_T_NAME, (DataType)new UnsignedLongLongDataType(this.dataTypeManager));
            Msg.warn((Object)this, (Object)("uintmax_t not defined.  Generated as `" + String.valueOf(this.uintmax_t) + "'"));
        }
        return this.uintmax_t;
    }

    private AbstractIntegerDataType getIntegralPointerType(boolean signed) {
        DataOrganization dataOrganization = this.dataTypeManager.getDataOrganization();
        int size = dataOrganization.getPointerSize();
        if (size < dataOrganization.getLongSize() && size >= dataOrganization.getIntegerSize()) {
            return signed ? new IntegerDataType(this.dataTypeManager) : new UnsignedIntegerDataType(this.dataTypeManager);
        }
        return signed ? new LongDataType(this.dataTypeManager) : new UnsignedLongDataType(this.dataTypeManager);
    }

    private TypeDef getSizeT() {
        if (this.size_t != null) {
            return this.size_t;
        }
        this.size_t = this.lookupTypeDef(SIZE_T_NAME);
        if (this.size_t == null) {
            this.size_t = new TypedefDataType(SIZE_T_NAME, (DataType)this.getIntegralPointerType(false));
            Msg.warn((Object)this, (Object)("size_t not defined.  Generated as `" + String.valueOf(this.size_t) + "'"));
        }
        return this.size_t;
    }

    private TypeDef getPtrDiffT() {
        if (this.ptrdiff_t != null) {
            return this.ptrdiff_t;
        }
        this.ptrdiff_t = this.lookupTypeDef(PTRDIFF_T_NAME);
        if (this.ptrdiff_t == null) {
            this.ptrdiff_t = new TypedefDataType(PTRDIFF_T_NAME, (DataType)this.getIntegralPointerType(true));
            Msg.warn((Object)this, (Object)("ptrdiff_t not defined.  Generated as `" + String.valueOf(this.ptrdiff_t) + "'"));
        }
        return this.ptrdiff_t;
    }

    private DataType intmax_t_LengthModification(String conversionSpecifier) {
        TypeDef intType = this.isUnsignedInteger(conversionSpecifier) ? this.getUIntMaxT() : this.getIntMaxT();
        return this.isIntegerPointer(conversionSpecifier) ? this.dataTypeManager.getPointer((DataType)intType) : intType;
    }

    private DataType size_t_LengthModification(String conversionSpecifier) {
        TypeDef sizeType = this.getSizeT();
        return this.isIntegerPointer(conversionSpecifier) ? this.dataTypeManager.getPointer((DataType)sizeType) : sizeType;
    }

    private DataType ptrdiff_t_LengthModification(String conversionSpecifier) {
        TypeDef type = this.isUnsignedInteger(conversionSpecifier) ? this.getSizeT() : this.getPtrDiffT();
        return this.isIntegerPointer(conversionSpecifier) ? this.dataTypeManager.getPointer((DataType)type) : type;
    }

    private DataType longDoubleLengthModification(String conversionSpecifier) {
        return new LongDoubleDataType(this.dataTypeManager);
    }

    private boolean isInteger(String conversionSpecifier) {
        return this.isUnsignedInteger(conversionSpecifier) || this.isSignedInteger(conversionSpecifier);
    }

    private boolean isDouble(String conversionSpecifier) {
        String doubleConversionSpecifierSet = "aAeEfFgG";
        char c = conversionSpecifier.charAt(0);
        return doubleConversionSpecifierSet.indexOf(c) != -1;
    }

    private boolean isUnsignedInteger(String conversionSpecifier) {
        String unsignedIntSpecifierSet = "ouxX";
        char c = conversionSpecifier.charAt(0);
        return unsignedIntSpecifierSet.indexOf(c) != -1;
    }

    private boolean isSignedInteger(String conversionSpecifier) {
        String signedIntSpecifierSet = "di";
        char c = conversionSpecifier.charAt(0);
        return signedIntSpecifierSet.indexOf(c) != -1;
    }

    private boolean isIntegerPointer(String conversionSpecifier) {
        String pointerSpecifierSet = "n";
        char c = conversionSpecifier.charAt(0);
        return pointerSpecifierSet.indexOf(c) != -1;
    }

    private boolean isVoidPointer(String conversionSpecifier) {
        String voidPointerSpecifierSet = "p";
        char c = conversionSpecifier.charAt(0);
        return voidPointerSpecifierSet.indexOf(c) != -1;
    }

    private boolean isFlag(char c) {
        String flagSpecifierSet = "0+ -#'";
        return flagSpecifierSet.indexOf(c) != -1;
    }

    private String extendLengthModifier(String lengthModifier, char nextChar) {
        if (lengthModifier.equals("h") && nextChar == 'h' || lengthModifier.equals("l") && nextChar == 'l') {
            return lengthModifier + Character.toString(nextChar);
        }
        return null;
    }

    private boolean isConversionSpecifier(char c) {
        return this.detectConversionSpecifier(c) != null;
    }

    private boolean isLengthModifier(char c) {
        return this.detectLengthModifier(c) != null;
    }

    private String detectLengthModifier(char c) {
        String lengthModifierSet = "hljztLq";
        return lengthModifierSet.indexOf(c) != -1 ? Character.toString(c) : null;
    }

    private String detectConversionSpecifier(char c) {
        String conversionSpecifierSet = "diuofeaFEApcsxXgGnCS";
        return conversionSpecifierSet.indexOf(c) != -1 ? Character.toString(c) : null;
    }

    public int skipToNextWhitespace(String formatStr, int i) {
        char c = formatStr.charAt(i);
        while (c != ' ') {
            c = formatStr.charAt(++i);
        }
        return i;
    }

    private class FormatParsingData {
        private String conversionSpecifier = null;
        private String lengthModifier = null;
        private boolean fieldWidthComplete = false;
        private boolean precisionComplete = false;
        private boolean inConversion = false;
        private int parameterIndex = 0;

        private FormatParsingData(FormatStringParser formatStringParser) {
        }

        private void setParameterIndex(int parameterIndex) {
            this.parameterIndex = parameterIndex;
        }

        private int getParameterIndex() {
            return this.parameterIndex;
        }

        private void setConversionSpecifier(String conversionSpecifier) {
            this.conversionSpecifier = conversionSpecifier;
        }

        private String getConversionSpecifier() {
            return this.conversionSpecifier;
        }

        private void setLengthModifier(String lengthModifier) {
            this.lengthModifier = lengthModifier;
        }

        private String getLengthModifier() {
            return this.lengthModifier;
        }

        private boolean isFieldWidthComplete() {
            return this.fieldWidthComplete;
        }

        private void setFieldWidthComplete(boolean fieldWidthComplete) {
            this.fieldWidthComplete = fieldWidthComplete;
        }

        private boolean isPrecisionComplete() {
            return this.precisionComplete;
        }

        private void setPrecisionComplete(boolean precisionComplete) {
            this.precisionComplete = precisionComplete;
        }

        private void setInConversion(boolean inConversion) {
            this.inConversion = inConversion;
        }

        private boolean isInConversion() {
            return this.inConversion;
        }

        private void clearData() {
            this.precisionComplete = false;
            this.fieldWidthComplete = false;
            this.lengthModifier = null;
            this.conversionSpecifier = null;
        }
    }
}

