/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.margin;

import docking.widgets.fieldpanel.support.AnchoredLayout;
import ghidra.app.decompiler.component.margin.LayoutPixelIndexMap;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class VerticalLayoutPixelIndexMap
implements LayoutPixelIndexMap {
    private BigInteger base = BigInteger.ZERO;
    private int[] yPositions = new int[0];
    private int size;

    @Override
    public int getPixel(BigInteger index) {
        return this.yPositions[index.subtract(this.base).intValueExact()];
    }

    protected int computeOff(int pixel) {
        int result = Arrays.binarySearch(this.yPositions, 0, this.size, pixel);
        if (result >= 0) {
            return result;
        }
        return -result - 2;
    }

    @Override
    public BigInteger getIndex(int pixel) {
        return this.base.add(BigInteger.valueOf(this.computeOff(pixel)));
    }

    public void layoutsChanged(List<AnchoredLayout> layouts) {
        this.size = layouts.size();
        if (this.yPositions.length < this.size) {
            this.yPositions = new int[this.size];
        }
        int i = 0;
        this.base = layouts.isEmpty() ? BigInteger.ZERO : layouts.get(0).getIndex();
        for (AnchoredLayout l : layouts) {
            assert (l.getIndex().subtract(this.base).intValueExact() == i);
            this.yPositions[i] = l.getYPos();
            ++i;
        }
    }
}

