/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.util.HelpLocation;

public class FilterOnNameOnlyAction
extends ToggleDockingAction {
    private final DataTypesProvider provider;

    public FilterOnNameOnlyAction(DataTypeManagerPlugin plugin, DataTypesProvider provider, String menuSubGroup) {
        super("Filter on Name Only", plugin.getName());
        this.provider = provider;
        this.setMenuBarData(new MenuData(new String[]{"Filter on Name Only"}, null, "VeryLast", -1, menuSubGroup));
        this.setDescription("Selected indicates to use only the data type name when filtering.");
        this.setEnabled(true);
        this.setSelected(false);
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Filter_Name_Only"));
    }

    public void setSelected(boolean newValue) {
        if (this.isSelected() == newValue) {
            return;
        }
        super.setSelected(newValue);
        this.provider.setFilterOnNameOnlyCallback(newValue);
    }
}

