/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.label.LabelMgrPlugin;
import ghidra.program.util.OperandFieldLocation;
import javax.swing.KeyStroke;

class SetOperandLabelAction
extends ListingContextAction {
    private LabelMgrPlugin plugin;
    private static final String[] POPUP_PATH = new String[]{"Set Associated Label..."};
    private static final KeyStroke KEYBINDING = KeyStroke.getKeyStroke(76, 10);

    SetOperandLabelAction(LabelMgrPlugin plugin) {
        super("Set Operand Label", plugin.getName());
        this.setPopupMenuData(new MenuData(POPUP_PATH, null, "Label"));
        this.setKeyBindingData(new KeyBindingData(KEYBINDING));
        this.plugin = plugin;
        this.setEnabled(true);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        if (!(context.getLocation() instanceof OperandFieldLocation)) {
            return false;
        }
        return !this.plugin.isOnExternalReference(context) && !this.plugin.isOnVariableReference(context) && this.plugin.isOnSymbol(context);
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.setOperandLabelCallback(context);
    }
}

