/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeDataFlavor;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import ghidra.app.plugin.core.symtable.dnd.SymbolDataFlavor;
import ghidra.app.plugin.core.symtable.dnd.SymbolTransferData;
import ghidra.app.util.SelectionTransferData;
import ghidra.app.util.SelectionTransferable;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SymbolGTreeDragNDropHandler
implements GTreeDragNDropHandler {
    private final SymbolTreePlugin plugin;

    SymbolGTreeDragNDropHandler(SymbolTreePlugin plugin) {
        this.plugin = plugin;
    }

    public void drop(GTreeNode destinationNode, Transferable transferable, int dropAction) {
        if (dropAction != 2) {
            return;
        }
        if (!(destinationNode instanceof SymbolTreeNode)) {
            return;
        }
        SymbolTreeNode destinationSymbolNode = (SymbolTreeNode)destinationNode;
        Namespace namespace = destinationSymbolNode.getNamespace();
        if (namespace == null) {
            return;
        }
        if (transferable.isDataFlavorSupported(SelectionTransferable.localProgramSelectionFlavor)) {
            try {
                Object transferData = transferable.getTransferData(SelectionTransferable.localProgramSelectionFlavor);
                SelectionTransferData selectionData = (SelectionTransferData)transferData;
                this.dropProgramSelection(namespace, selectionData);
                return;
            }
            catch (UnsupportedFlavorException e) {
                Msg.showError((Object)this, (Component)this.plugin.getTool().getToolFrame(), (String)"Unsupported Data Flavor", (Object)("Unable to handle dropping of given data flavor: " + e.getMessage()));
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)this.plugin.getTool().getToolFrame(), (String)"Unexpected Exception", (Object)"Unable to handle dropping of given data", (Throwable)e);
            }
        }
        try {
            Object transferData = transferable.getTransferData(SymbolTreeDataFlavor.DATA_FLAVOR);
            if (transferData instanceof List) {
                this.dropNodeList(namespace, transferData);
                return;
            }
        }
        catch (UnsupportedFlavorException e) {
            Msg.showError((Object)this, (Component)this.plugin.getTool().getToolFrame(), (String)"Unsupported Data Flavor", (Object)("Unable to handle dropping of given data flavor: " + e.getMessage()));
        }
        catch (IOException e) {
            Msg.showError((Object)this, (Component)this.plugin.getTool().getToolFrame(), (String)"Unexpected Exception", (Object)"Unable to handle dropping of given data", (Throwable)e);
        }
    }

    private void dropProgramSelection(Namespace namespace, SelectionTransferData selectionData) {
        ArrayList<Symbol> symbolsToMove = new ArrayList<Symbol>();
        Program program = this.plugin.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        AddressSetView addressSet = selectionData.getAddressSet();
        FunctionIterator iterator = functionManager.getFunctions(addressSet, true);
        for (Function function : iterator) {
            symbolsToMove.add(function.getSymbol());
        }
        SymbolTreeProvider provider = this.plugin.getProvider();
        if (provider.reparentSymbols(namespace, symbolsToMove) != symbolsToMove.size()) {
            this.plugin.getTool().setStatusInfo("Failed to move one more specified symbols");
        }
    }

    private void dropNodeList(Namespace namespace, Object transferData) {
        List nodeList = (List)transferData;
        ArrayList<Symbol> symbolsToMoveList = new ArrayList<Symbol>();
        for (GTreeNode node : nodeList) {
            SymbolNode symbolNode = (SymbolNode)node;
            Symbol symbol = symbolNode.getSymbol();
            symbolsToMoveList.add(symbol);
        }
        SymbolTreeProvider provider = this.plugin.getProvider();
        if (provider.reparentSymbols(namespace, symbolsToMoveList) != symbolsToMoveList.size()) {
            this.plugin.getTool().setStatusInfo("Failed to move one more specified symbols");
        }
    }

    public int getSupportedDragActions() {
        return 2;
    }

    public boolean isDropSiteOk(GTreeNode destinationUserNode, DataFlavor[] flavors, int dropAction) {
        if (dropAction != 2) {
            return false;
        }
        Program program = this.plugin.getProgram();
        if (program == null || program.isClosed()) {
            return false;
        }
        if (!(destinationUserNode instanceof SymbolTreeNode)) {
            return false;
        }
        SymbolTreeNode node = (SymbolTreeNode)destinationUserNode;
        return node.supportsDataFlavors(flavors);
    }

    public boolean isStartDragOk(List<GTreeNode> dragUserData, int dragAction) {
        if (dragAction != 2) {
            return false;
        }
        return dragUserData.size() != 0;
    }

    public DataFlavor[] getSupportedDataFlavors(List<GTreeNode> transferNodes) {
        HashSet<DataFlavor> flavorSet = new HashSet<DataFlavor>();
        for (GTreeNode node : transferNodes) {
            SymbolTreeNode symbolNode = (SymbolTreeNode)node;
            DataFlavor flavor = symbolNode.getNodeDataFlavor();
            if (flavor != null) {
                flavorSet.add(flavor);
            }
            if (!(symbolNode instanceof SymbolNode)) continue;
            flavorSet.add(SymbolDataFlavor.DATA_FLAVOR);
        }
        return flavorSet.toArray(new DataFlavor[flavorSet.size()]);
    }

    public Object getTransferData(List<GTreeNode> transferNodes, DataFlavor flavor) throws UnsupportedFlavorException {
        if (SymbolDataFlavor.DATA_FLAVOR.equals(flavor)) {
            return this.getSymbols(transferNodes);
        }
        if (SymbolTreeDataFlavor.DATA_FLAVOR.equals(flavor)) {
            ArrayList<SymbolTreeNode> nodes = new ArrayList<SymbolTreeNode>();
            for (GTreeNode node : transferNodes) {
                SymbolTreeNode symbolNode = (SymbolTreeNode)node;
                nodes.add(symbolNode);
            }
            return nodes;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private SymbolTransferData getSymbols(List<GTreeNode> transferNodes) {
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        for (GTreeNode node : transferNodes) {
            if (!(node instanceof SymbolNode)) continue;
            SymbolNode symbolNode = (SymbolNode)node;
            symbols.add(symbolNode.getSymbol());
        }
        SymbolTreeProvider provider = this.plugin.getProvider();
        GTree tree = provider.getTree();
        return new SymbolTransferData((Component)tree, symbols);
    }
}

