/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.FixedField;
import db.IndexField;
import db.IntField;
import db.LongField;
import db.NodeMgr;
import db.Schema;
import db.StringField;
import db.Table;
import java.io.IOException;

class TableRecord
implements Comparable<TableRecord> {
    private static final int NAME_COLUMN = 0;
    private static final int VERSION_COLUMN = 1;
    private static final int BUFFER_ID_COLUMN = 2;
    private static final int KEY_TYPE_COLUMN = 3;
    private static final int FIELD_TYPES_COLUMN = 4;
    private static final int FIELD_NAMES_COLUMN = 5;
    private static final int COLUMN_INDEXED_COLUMN = 6;
    private static final int MAX_KEY_COLUMN = 7;
    private static final int RECORD_COUNT_COLUMN = 8;
    private static Field[] fields = new Field[]{StringField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE, ByteField.INSTANCE, BinaryField.INSTANCE, StringField.INSTANCE, IntField.INSTANCE, LongField.INSTANCE, IntField.INSTANCE};
    private static String[] tableRecordFieldNames = new String[]{"TableName", "SchemaVersion", "RootBufferId", "KeyType", "FieldTypes", "FieldNames", "IndexColumn", "MaxKey", "RecordCount"};
    private static Schema schema = new Schema(0, "TableNum", fields, tableRecordFieldNames);
    private DBRecord record;
    private Schema tableSchema;
    private Table table;

    TableRecord(long tableNum, String name, Schema tableSchema, int indexedColumn) {
        this.tableSchema = tableSchema;
        this.record = schema.createRecord(tableNum);
        this.record.setString(0, name);
        this.record.setByteValue(3, tableSchema.getEncodedKeyFieldType());
        this.record.setBinaryData(4, tableSchema.getEncodedFieldTypes());
        this.record.setString(5, tableSchema.getPackedFieldNames());
        this.record.setIntValue(1, tableSchema.getVersion());
        this.record.setIntValue(6, indexedColumn);
        this.record.setLongValue(7, Long.MIN_VALUE);
        this.record.setIntValue(8, 0);
        this.record.setIntValue(2, -1);
    }

    TableRecord(DBHandle dbh, DBRecord record) throws IOException {
        this.tableSchema = TableRecord.parseSchema(dbh, record);
        this.record = record;
    }

    DBRecord getRecord() {
        return this.record;
    }

    void setTable(Table table) {
        this.table = table;
    }

    void setRecord(DBHandle dbh, DBRecord record) throws IOException {
        this.tableSchema = TableRecord.parseSchema(dbh, record);
        this.record = record;
        if (this.table != null) {
            this.table.tableRecordChanged();
        }
    }

    void invalidate() {
        if (this.table != null) {
            this.table.invalidate();
            this.table = null;
        }
        this.record = null;
        this.tableSchema = null;
    }

    long getTableNum() {
        return this.record.getKey();
    }

    String getName() {
        return this.record.getString(0);
    }

    void setName(String name) {
        this.record.setString(0, name);
    }

    private static Schema parseSchema(DBHandle dbh, DBRecord record) throws IOException {
        Schema tableSchema = new Schema(record.getIntValue(1), record.getByteValue(3), record.getBinaryData(4), record.getString(5));
        TableRecord.forceUseOfVariableLengthKeyNodesIfNeeded(dbh, tableSchema, record.getIntValue(2));
        return tableSchema;
    }

    private static void forceUseOfVariableLengthKeyNodesIfNeeded(DBHandle dbh, Schema tableSchema, int rootBufferId) throws IOException {
        if (rootBufferId < 0) {
            return;
        }
        Field keyType = tableSchema.getKeyFieldType();
        if (keyType.isVariableLength()) {
            return;
        }
        if (keyType instanceof LongField || keyType instanceof IndexField || keyType instanceof FixedField) {
            return;
        }
        if (NodeMgr.isVarKeyNode(dbh.getBufferMgr(), rootBufferId)) {
            tableSchema.forceUseOfVariableLengthKeyNodes();
        }
    }

    Schema getSchema() {
        return this.tableSchema;
    }

    int getRootBufferId() {
        return this.record.getIntValue(2);
    }

    void setRootBufferId(int id) {
        this.record.setIntValue(2, id);
    }

    long getMaxKey() {
        return this.record.getLongValue(7);
    }

    void setMaxKey(long maxKey) {
        this.record.setLongValue(7, maxKey);
    }

    int getRecordCount() {
        return this.record == null ? 0 : this.record.getIntValue(8);
    }

    void setRecordCount(int count) {
        this.record.setIntValue(8, count);
    }

    int getIndexedColumn() {
        return this.record.getIntValue(6);
    }

    static Schema getTableRecordSchema() {
        return schema;
    }

    @Override
    public int compareTo(TableRecord otherRecord) {
        long otherKey;
        long myKey = this.record.getKey();
        if (myKey == (otherKey = otherRecord.record.getKey())) {
            return 0;
        }
        if (myKey < otherKey) {
            return -1;
        }
        return 1;
    }
}

