/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task.gui.taskview;

import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.framework.task.GScheduledTask;
import ghidra.framework.task.GTaskGroup;
import ghidra.framework.task.gui.GProgressBar;
import ghidra.framework.task.gui.taskview.GroupInfo;
import ghidra.framework.task.gui.taskview.ScheduledTaskPanel;
import ghidra.framework.task.gui.taskview.TaskInfo;
import java.awt.Color;
import java.awt.Container;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public abstract class AbstractTaskInfo
implements Comparable<AbstractTaskInfo> {
    private final boolean useAnimation;
    private Animator backgroundAnimator;
    protected ScheduledTaskPanel component;
    protected GTaskGroup group;

    AbstractTaskInfo(GTaskGroup group, boolean useAnimation) {
        this.group = group;
        this.useAnimation = useAnimation;
    }

    protected abstract String getLabelText();

    public GTaskGroup getGroup() {
        return this.group;
    }

    @Override
    public int compareTo(AbstractTaskInfo o) {
        int result = this.getGroup().compareTo(o.getGroup());
        if (result == 0) {
            if (this instanceof GroupInfo) {
                return -1;
            }
            if (o instanceof GroupInfo) {
                return 1;
            }
            GScheduledTask myTask = ((TaskInfo)this).getScheduledTask();
            GScheduledTask otherTask = ((TaskInfo)o).getScheduledTask();
            return myTask.compareTo(otherTask);
        }
        return result;
    }

    public ScheduledTaskPanel getComponent() {
        if (this.component == null) {
            this.component = new ScheduledTaskPanel(this.getLabelText(), this.getIndention());
            if (this.useAnimation) {
                GColor startColor = GThemeDefaults.Colors.Palette.YELLOW;
                GColor endColor = GThemeDefaults.Colors.BACKGROUND;
                this.backgroundAnimator = PropertySetter.createAnimator((int)4000, (Object)this, (String)"Background", (Object[])new Color[]{startColor, endColor});
                this.backgroundAnimator.start();
            }
        }
        return this.component;
    }

    public void setBackground(Color c) {
        this.component.setBackground(c);
    }

    protected int getIndention() {
        return 0;
    }

    public GProgressBar setRunning() {
        this.getComponent().addProgressBar();
        if (this.backgroundAnimator != null) {
            this.backgroundAnimator.stop();
            this.component.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
            this.backgroundAnimator = null;
        }
        return this.getComponent().getProgressBar();
    }

    public void setScrollFraction(float fraction) {
        Container grandParent;
        this.component.setHiddenViewAmount(fraction);
        this.component.invalidate();
        Container parent = this.component.getParent();
        if (parent != null && (grandParent = parent.getParent()) != null) {
            grandParent.validate();
        }
    }
}

