/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.protocol.ExeSpecifier;
import ghidra.features.bsim.query.protocol.FunctionEntry;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class PairNote {
    private ExeSpecifier exe1;
    private FunctionEntry func1;
    private ExeSpecifier exe2;
    private FunctionEntry func2;
    private double sim;
    private double signif;
    private double dotprod;
    private int count1;
    private int count2;
    private int icount;

    public double getSimilarity() {
        return this.sim;
    }

    public double getSignificance() {
        return this.signif;
    }

    public double getDotProduct() {
        return this.dotprod;
    }

    public int getFunc1HashCount() {
        return this.count1;
    }

    public int getFunc2HashCount() {
        return this.count2;
    }

    public int getIntersectionCount() {
        return this.icount;
    }

    public PairNote() {
    }

    public PairNote(FunctionDescription f1, FunctionDescription f2, double sm, double sf, double dp, int c1, int c2, int ic) {
        this.exe1 = new ExeSpecifier();
        this.exe1.transfer(f1.getExecutableRecord());
        this.func1 = new FunctionEntry(f1);
        this.exe2 = new ExeSpecifier();
        this.exe2.transfer(f2.getExecutableRecord());
        this.func2 = new FunctionEntry(f2);
        this.sim = sm;
        this.signif = sf;
        this.dotprod = dp;
        this.count1 = c1;
        this.count2 = c2;
        this.icount = ic;
    }

    public void saveXml(Writer writer) throws IOException {
        writer.append("<note>\n");
        this.exe1.saveXml(writer);
        this.func1.saveXml(writer);
        this.exe2.saveXml(writer);
        this.func2.saveXml(writer);
        writer.append(" <sim>").append(Double.toString(this.sim)).append("</sim>\n");
        writer.append(" <sig>").append(Double.toString(this.signif)).append("</sig>\n");
        writer.append(" <dot>").append(Double.toString(this.dotprod)).append("</dot>\n");
        writer.append(" <cnt1>").append(Integer.toString(this.count1)).append("</cnt1>\n");
        writer.append(" <cnt2>").append(Integer.toString(this.count2)).append("</cnt2>\n");
        writer.append(" <icnt>").append(Integer.toString(this.icount)).append("</icnt>\n");
        writer.append("</note>\n");
    }

    public void restoreXml(XmlPullParser parser) {
        XmlElement startEl = parser.start(new String[]{"note"});
        this.exe1 = new ExeSpecifier();
        this.exe1.restoreXml(parser);
        this.func1 = FunctionEntry.restoreXml(parser);
        this.exe2 = new ExeSpecifier();
        this.exe2.restoreXml(parser);
        this.func2 = FunctionEntry.restoreXml(parser);
        parser.start(new String[]{"sim"});
        this.sim = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"sig"});
        this.signif = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"dot"});
        this.dotprod = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"cnt1"});
        this.count1 = SpecXmlUtils.decodeInt((String)parser.end().getText());
        this.count2 = SpecXmlUtils.decodeInt((String)parser.end().getText());
        this.icount = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.end(startEl);
    }
}

