/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.art.ArtConstants;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.ArtHeaderFactory;
import ghidra.file.formats.android.art.UnsupportedArtVersionException;
import ghidra.file.formats.android.oat.OatUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class ArtAnalyzer
extends FileFormatAnalyzer {
    public String getName() {
        return "Android ART Header Format";
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Analyzes the Android ART information in this program.";
    }

    public boolean canAnalyze(Program program) {
        return ArtConstants.isART(program) || OatUtilities.isOAT(program);
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        Address address = ArtConstants.findART(program);
        if (address == null) {
            return false;
        }
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
        try {
            ArtHeader header = ArtHeaderFactory.newArtHeader(reader);
            DataType headerDataType = header.toDataType();
            Address imageBase = this.toAddr(program, header.getImageBegin());
            if ("Raw Binary".equals(program.getExecutableFormat())) {
                program.setImageBase(imageBase, true);
                this.createData(program, imageBase, headerDataType);
            } else {
                this.createData(program, address, headerDataType);
            }
            header.markup(program, monitor);
            return true;
        }
        catch (UnsupportedArtVersionException e) {
            log.appendException((Throwable)e);
        }
        catch (Exception e) {
            throw e;
        }
        return false;
    }
}

