/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTMatchUtil;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.wizard.add.AddToSessionData;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AddToSessionTask
extends Task {
    private final AddToSessionData data;
    private final VTController controller;

    public AddToSessionTask(VTController controller, AddToSessionData data) {
        super("Merge Version Tracking Session", true, true, true);
        this.controller = controller;
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        VTSession session = null;
        session = this.controller.getSession();
        Program sourceProgram = session.getSourceProgram();
        Program destinationProgram = session.getDestinationProgram();
        boolean excludeAcceptedMatches = this.data.shouldExcludeAcceptedMatches();
        AddressSetView sourceAddressSet = this.getSourceAddressSet();
        AddressSetView destinationAddressSet = this.getDestinationAddressSet();
        if (excludeAcceptedMatches) {
            sourceAddressSet = this.excludeAcceptedMatches(sourceAddressSet, true);
            destinationAddressSet = this.excludeAcceptedMatches(destinationAddressSet, false);
        }
        int transactionID = this.startTransaction(session);
        boolean completedSucessfully = false;
        try {
            session.setEventsEnabled(false);
            List<VTProgramCorrelatorFactory> correlatorFactories = this.data.getCorrelators();
            Map<VTProgramCorrelatorFactory, VTOptions> optionsMap = this.data.getOptions();
            ArrayList<VTProgramCorrelator> noMatchList = new ArrayList<VTProgramCorrelator>();
            for (VTProgramCorrelatorFactory factory : correlatorFactories) {
                VTOptions options;
                VTProgramCorrelator correlator = factory.createCorrelator(sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options = optionsMap.get(factory));
                VTMatchSet resultSet = correlator.correlate(session, monitor);
                if (resultSet.getMatchCount() != 0) continue;
                noMatchList.add(correlator);
            }
            if (!noMatchList.isEmpty()) {
                StringBuffer messageBuffer = new StringBuffer("No matches were found by the following program correlators: ");
                for (VTProgramCorrelator vtProgramCorrelator : noMatchList) {
                    messageBuffer.append("\n  " + vtProgramCorrelator.getName());
                }
                Msg.showInfo((Object)((Object)this), null, (String)"Version Tracking: Add To Session", (Object)messageBuffer.toString());
            }
            completedSucessfully = true;
        }
        catch (CancelledException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                Msg.showWarn((Object)((Object)this), null, (String)"Add to Session Cancelled", (Object)"Correlation canceled by user.");
            } else {
                Msg.showError((Object)((Object)this), null, (String)"Add to Session Cancelled - Unexpected Exception", (Object)("Correlation cancelled due to exception: " + cause.getMessage()), (Throwable)e);
            }
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)"Add to Session Cancelled - Unexpected Exception", (Object)("Correlation cancelled due to exception: " + e.getMessage()), (Throwable)e);
        }
        finally {
            session.setEventsEnabled(true);
            this.endTransaction(session, transactionID, completedSucessfully);
        }
    }

    private AddressSetView getSourceAddressSet() {
        if (!this.data.shouldLimitAddressSets()) {
            return this.data.getSourceProgram().getMemory();
        }
        switch (this.data.getSourceAddressSetChoice()) {
            case MANUALLY_DEFINED: {
                return this.data.getCustomSourceAddressSet();
            }
            case SELECTION: {
                return this.data.getSourceSelection();
            }
        }
        return this.data.getSourceProgram().getMemory();
    }

    private AddressSetView getDestinationAddressSet() {
        if (!this.data.shouldLimitAddressSets()) {
            return this.data.getDestinationProgram().getMemory();
        }
        switch (this.data.getDestinationAddressSetChoice()) {
            case MANUALLY_DEFINED: {
                return this.data.getCustomDestinationAddressSet();
            }
            case SELECTION: {
                return this.data.getDestinationSelection();
            }
        }
        return this.data.getDestinationProgram().getMemory();
    }

    private void endTransaction(VTSession session, int transactionID, boolean completedSucessfully) {
        if (transactionID == -1) {
            return;
        }
        ((DomainObjectAdapterDB)session).endTransaction(transactionID, completedSucessfully);
    }

    private int startTransaction(VTSession session) {
        if (session instanceof DomainObjectAdapterDB) {
            return ((DomainObjectAdapterDB)session).startTransaction("Correlate");
        }
        return -1;
    }

    private AddressSet excludeAcceptedMatches(AddressSetView addrSetView, boolean source) {
        VTSession session = this.data.getSession();
        AddressSet addrSet = new AddressSet(addrSetView);
        if (session != null) {
            List<VTMatchSet> matchSets = session.getMatchSets();
            for (VTMatchSet vtMatchSet : matchSets) {
                Collection<VTMatch> matches = vtMatchSet.getMatches();
                for (VTMatch vtMatch : matches) {
                    VTAssociationStatus status = vtMatch.getAssociation().getStatus();
                    if (status != VTAssociationStatus.ACCEPTED) continue;
                    AddressSetView matchAddresses = VTMatchUtil.getMatchAddresses(vtMatch, source);
                    addrSet.delete(matchAddresses);
                }
            }
        }
        return addrSet;
    }
}

