/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.EdgeAwareLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.EdgePredicated;
import org.jungrapht.visualization.layout.algorithms.EdgeSorting;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.algorithms.TreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.VertexPredicated;
import org.jungrapht.visualization.layout.algorithms.VertexSorting;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeAwareTreeLayoutAlgorithm<V, E>
extends TreeLayoutAlgorithm<V>
implements TreeLayout<V>,
EdgeAwareLayoutAlgorithm<V, E>,
EdgeSorting<E>,
EdgePredicated<E>,
VertexSorting<V>,
VertexPredicated<V> {
    private static final Logger log = LoggerFactory.getLogger(EdgeAwareTreeLayoutAlgorithm.class);
    protected Predicate<V> vertexPredicate;
    protected Predicate<E> edgePredicate;
    protected Comparator<V> vertexComparator;
    protected Comparator<E> edgeComparator;
    protected boolean alignFavoredEdges;

    public static <V, E> Builder<V, E, ?, ?> edgeAwareBuilder() {
        return new Builder();
    }

    public EdgeAwareTreeLayoutAlgorithm() {
        this(EdgeAwareTreeLayoutAlgorithm.edgeAwareBuilder());
    }

    protected EdgeAwareTreeLayoutAlgorithm(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.vertexPredicate = builder.vertexPredicate;
        this.edgePredicate = builder.edgePredicate;
        this.vertexComparator = builder.vertexComparator;
        this.edgeComparator = builder.edgeComparator;
        this.alignFavoredEdges = builder.alignFavoredEdges;
    }

    @Override
    public void setVertexPredicate(Predicate<V> vertexPredicate) {
        this.vertexPredicate = vertexPredicate;
    }

    @Override
    public void setEdgePredicate(Predicate<E> edgePredicate) {
        this.edgePredicate = edgePredicate;
    }

    @Override
    public void setVertexComparator(Comparator<V> vertexComparator) {
        if (vertexComparator == null) {
            vertexComparator = (v1, v2) -> 0;
        }
        this.vertexComparator = vertexComparator;
    }

    @Override
    public void setEdgeComparator(Comparator<E> edgeComparator) {
        if (edgeComparator == null) {
            edgeComparator = (e1, e2) -> 0;
        }
        this.edgeComparator = edgeComparator;
    }

    @Override
    protected Set<V> buildTree(LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            this.expandLayout = false;
            this.correctOverlap = false;
            return Collections.emptySet();
        }
        if (graph.vertexSet().size() == 1) {
            Object loner = graph.vertexSet().stream().findFirst().get();
            layoutModel.set(loner, layoutModel.getWidth() / 2, layoutModel.getHeight() / 2);
            this.expandLayout = false;
            this.correctOverlap = false;
            return graph.vertexSet();
        }
        Set<V> roots = this.alignFavoredEdges ? this.alignBuildTree(layoutModel) : super.buildTree(layoutModel);
        return roots;
    }

    @Override
    protected void buildTree(LayoutModel<V> layoutModel, V vertex, int x, int y, Set<V> seen) {
        if (seen.add(vertex)) {
            Graph graph = layoutModel.getGraph();
            log.trace("buildTree placing {}", vertex);
            log.trace("Set vertex {} to {}", vertex, (Object)Point.of(x, y += this.verticalVertexSpacing));
            layoutModel.set(vertex, x, y);
            this.merge(layoutModel, vertex);
            double sizeXofCurrent = ((Rectangle)this.baseBounds.get(vertex)).width;
            x = (int)((double)x - sizeXofCurrent / 2.0);
            for (Object edge : graph.outgoingEdgesOf(vertex).stream().sorted(this.edgeComparator).collect(Collectors.toCollection(LinkedHashSet::new))) {
                Object v;
                if (!this.edgePredicate.test(edge) && !graph.incomingEdgesOf(graph.getEdgeTarget(edge)).stream().noneMatch(this.edgePredicate) || this.rootPredicate.test(v = graph.getEdgeTarget(edge)) || seen.contains(v)) continue;
                double sizeXofChild = this.baseBounds.getOrDefault((Object)v, Rectangle.IDENTITY).width;
                x = (int)((double)x + sizeXofChild / 2.0);
                this.buildTree(layoutModel, v, x, y, seen);
                this.merge(layoutModel, v);
                x = (int)((double)x + (sizeXofChild / 2.0 + (double)this.horizontalVertexSpacing));
            }
        }
    }

    @Override
    protected int calculateWidth(LayoutModel<V> layoutModel, V vertex, Set<V> seen) {
        if (seen.add(vertex)) {
            Graph graph = layoutModel.getGraph();
            int width = Math.max(0, graph.outgoingEdgesOf(vertex).stream().sorted(this.edgeComparator).filter(e -> this.edgePredicate.test(e) || graph.incomingEdgesOf(graph.getEdgeTarget(e)).stream().noneMatch(this.edgePredicate)).map(arg_0 -> graph.getEdgeTarget(arg_0)).filter(v -> !this.rootPredicate.test(v) && !seen.contains(v)).mapToInt(element -> this.calculateWidth(layoutModel, element, seen) + this.horizontalVertexSpacing).sum() - this.horizontalVertexSpacing);
            log.trace("calcWidth baseWidths put {} {}", vertex, (Object)width);
            this.baseBounds.merge(vertex, Rectangle.of(0, 0, width, 0), (r, t) -> Rectangle.of(r.x, r.y, t.width, r.height));
            return width;
        }
        return 0;
    }

    @Override
    protected int calculateHeight(LayoutModel<V> layoutModel, V vertex, Set<V> seen) {
        if (seen.add(vertex)) {
            Graph graph = layoutModel.getGraph();
            int height = graph.outgoingEdgesOf(vertex).stream().sorted(this.edgeComparator).filter(e -> this.edgePredicate.test(e) || graph.incomingEdgesOf(graph.getEdgeTarget(e)).stream().noneMatch(this.edgePredicate)).map(arg_0 -> graph.getEdgeTarget(arg_0)).filter(v -> !this.rootPredicate.test(v) && !seen.contains(v)).mapToInt(element -> this.calculateHeight(layoutModel, element, seen) + this.verticalVertexSpacing).max().orElse(0);
            this.baseBounds.merge(vertex, Rectangle.of(0, 0, 0, height), (r, t) -> Rectangle.of(r.x, r.y, r.width, t.height));
            return height;
        }
        return 0;
    }

    protected Set<V> alignBuildTree(LayoutModel<V> layoutModel) {
        Set<V> roots = super.buildTree(layoutModel);
        Graph graph = layoutModel.getGraph();
        for (Object vertex : graph.vertexSet()) {
            if (!this.vertexPredicate.test(vertex) && !graph.outgoingEdgesOf(vertex).stream().anyMatch(this.edgePredicate) && !graph.incomingEdgesOf(vertex).stream().anyMatch(this.edgePredicate)) continue;
            Rectangle vertexRectangle = this.baseBounds.getOrDefault(vertex, Rectangle.IDENTITY);
            layoutModel.set(vertex, vertexRectangle.x, vertexRectangle.y);
        }
        return roots;
    }

    public static class Builder<V, E, T extends EdgeAwareTreeLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    extends TreeLayoutAlgorithm.Builder<V, T, B>
    implements EdgeAwareLayoutAlgorithm.Builder<V, E, T, B> {
        protected Predicate<V> vertexPredicate = v -> false;
        protected Predicate<E> edgePredicate = e -> false;
        protected Comparator<V> vertexComparator = (v1, v2) -> 0;
        protected Comparator<E> edgeComparator = (e1, e2) -> 0;
        protected boolean alignFavoredEdges = true;

        @Override
        protected B self() {
            return (B)this;
        }

        public B vertexPredicate(Predicate<V> vertexPredicate) {
            this.vertexPredicate = vertexPredicate;
            return (B)this.self();
        }

        public B edgePredicate(Predicate<E> edgePredicate) {
            this.edgePredicate = edgePredicate;
            return (B)this.self();
        }

        public B vertexComparator(Comparator<V> vertexComparator) {
            this.vertexComparator = vertexComparator;
            return (B)this.self();
        }

        public B edgeComparator(Comparator<E> edgeComparator) {
            this.edgeComparator = edgeComparator;
            return (B)this.self();
        }

        public B alignFavoredEdges(boolean alignFavoredEdges) {
            this.alignFavoredEdges = alignFavoredEdges;
            return (B)this.self();
        }

        @Override
        public T build() {
            return (T)new EdgeAwareTreeLayoutAlgorithm(this);
        }
    }
}

