/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.jungrapht.visualization.DefaultSatelliteVisualizationViewer;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.DefaultSatelliteGraphMouse;
import org.jungrapht.visualization.transform.MutableTransformer;

public interface SatelliteVisualizationViewer<V, E>
extends VisualizationViewer<V, E> {
    public static final String SATELLITE_BACKGROUND_TRANSPARENT = "jungrapht.satelliteBackgroundTransparent";

    public static <V, E> Builder<V, E, ?, ?> builder(VisualizationViewer<V, E> master) {
        return new Builder(master);
    }

    public VisualizationViewer<V, E> getMaster();

    public Color getLensColor();

    public static class Builder<V, E, T extends DefaultSatelliteVisualizationViewer<V, E>, B extends Builder<V, E, T, B>>
    extends VisualizationViewer.Builder<V, E, T, B> {
        protected VisualizationViewer<V, E> master;
        protected boolean transparent = Boolean.parseBoolean(System.getProperty("jungrapht.satelliteBackgroundTransparent", "false"));
        protected Color lensColor = Color.getColor("jungrapht.satelliteLensColor", Color.decode("0xFFFAE0"));

        public B transparent(boolean transparent) {
            this.transparent = transparent;
            return (B)((Builder)this.self());
        }

        public B lensColor(Color lensColor) {
            this.lensColor = lensColor;
            return (B)((Builder)this.self());
        }

        protected Builder(VisualizationViewer<V, E> master) {
            super(master.getVisualizationModel());
            this.graphMouse = new DefaultSatelliteGraphMouse();
            this.master = master;
        }

        private Dimension getViewSize() {
            return this.viewSize;
        }

        @Override
        public T build() {
            return (T)new DefaultSatelliteVisualizationViewer(this);
        }
    }

    public static class ViewLens<V, E>
    implements VisualizationServer.Paintable {
        VisualizationViewer<V, E> master;
        SatelliteVisualizationViewer<V, E> vv;

        public ViewLens(SatelliteVisualizationViewer<V, E> vv, VisualizationViewer<V, E> master) {
            this.vv = vv;
            this.master = master;
        }

        @Override
        public void paint(Graphics g) {
            MutableTransformer masterViewTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
            MutableTransformer masterLayoutTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            MutableTransformer vvLayoutTransformer = this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            Shape lens = this.master.getBounds();
            lens = masterViewTransformer.inverseTransform(lens);
            lens = masterLayoutTransformer.inverseTransform(lens);
            lens = vvLayoutTransformer.transform(lens);
            Graphics2D g2d = (Graphics2D)g;
            Color old = g.getColor();
            Color lensColor = this.vv.getLensColor();
            Color darker = new Color(Math.max((int)((double)lensColor.getRed() * 0.95), 0), Math.max((int)((double)lensColor.getGreen() * 0.95), 0), Math.max((int)((double)lensColor.getBlue() * 0.95), 0), lensColor.getAlpha());
            this.vv.setBackground(darker);
            g.setColor(lensColor);
            g2d.fill(lens);
            g.setColor(Color.black);
            g2d.draw(lens);
            g.setColor(old);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }
}

