/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.MonitorContendedEnterEvent;
import com.sun.jdi.event.MonitorContendedEnteredEvent;
import com.sun.jdi.event.MonitorWaitEvent;
import com.sun.jdi.event.MonitorWaitedEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import ghidra.app.plugin.core.debug.client.tracermi.RmiBatch;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTrace;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTransaction;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventsListenerAdapter;
import ghidra.dbg.jdi.manager.JdiReason;
import ghidra.dbg.jdi.manager.impl.DebugStatus;
import ghidra.dbg.jdi.manager.impl.JdiManagerImpl;
import ghidra.dbg.jdi.rmi.jpda.HookState;
import ghidra.dbg.jdi.rmi.jpda.JdiCommands;
import ghidra.dbg.jdi.rmi.jpda.JdiConnector;
import ghidra.dbg.jdi.rmi.jpda.VmState;
import java.util.HashMap;
import java.util.Map;

public class JdiHooks
implements JdiEventsListenerAdapter {
    private JdiConnector connector;
    private JdiCommands cmds;
    private HookState hookState;
    private Map<VirtualMachine, VmState> vmStates = new HashMap<VirtualMachine, VmState>();

    public JdiHooks(JdiConnector connector, JdiCommands cmds) {
        this.connector = connector;
        this.cmds = cmds;
    }

    private void setCommands(JdiCommands commands) {
        this.cmds = commands;
        this.hookState = new HookState(commands);
    }

    @Override
    public DebugStatus vmStarted(VMStartEvent event, JdiCause cause) {
        this.setCommands(this.connector.getCommands());
        JdiManagerImpl jdi = this.connector.getJdi();
        VirtualMachine vm = event == null ? jdi.getCurrentVM() : event.virtualMachine();
        jdi.setCurrentVM(vm);
        jdi.addVM(vm);
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        try (RmiBatch batch = this.hookState.batch();
             RmiTransaction tx = trace.openTx("New VM " + vm.description());){
            this.cmds.putVMs();
            this.enableCurrentVM();
        }
        return DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugStatus vmDied(VMDeathEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("VMDeathEvent");
    }

    @Override
    public DebugStatus vmDisconnected(VMDisconnectEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        VirtualMachine eventVM = evt.virtualMachine();
        VmState state = this.vmStates.get(eventVM);
        try (RmiTransaction tx = trace.openTx("VM disconnected: " + eventVM.description());){
            state.recordStateExited(eventVM, "VM disconnected");
        }
        this.disableCurrentVM();
        return DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugStatus threadStarted(ThreadStartEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("ThreadStartEvent");
    }

    @Override
    public DebugStatus threadExited(ThreadDeathEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("ThreadDeathEvent");
    }

    @Override
    public DebugStatus stepComplete(StepEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return DebugStatus.BREAK;
    }

    @Override
    public DebugStatus breakpointHit(BreakpointEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return DebugStatus.BREAK;
    }

    @Override
    public DebugStatus accessWatchpointHit(AccessWatchpointEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return DebugStatus.BREAK;
    }

    @Override
    public DebugStatus watchpointHit(WatchpointEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return DebugStatus.BREAK;
    }

    @Override
    public DebugStatus watchpointModified(ModificationWatchpointEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return DebugStatus.BREAK;
    }

    @Override
    public DebugStatus exceptionHit(ExceptionEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("ExceptionEvent");
    }

    @Override
    public DebugStatus methodEntry(MethodEntryEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("MethodEntryEvent");
    }

    @Override
    public DebugStatus methodExit(MethodExitEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("MethodExitEvent");
    }

    @Override
    public DebugStatus classPrepare(ClassPrepareEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("ClassPrepareEvent");
    }

    @Override
    public DebugStatus classUnload(ClassUnloadEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("ClassUnloadEvent");
    }

    @Override
    public DebugStatus monitorContendedEnter(MonitorContendedEnterEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("MonitorContendedEnterEvent");
    }

    @Override
    public DebugStatus monitorContendedEntered(MonitorContendedEnteredEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("MonitorContendedEnteredEvent");
    }

    @Override
    public DebugStatus monitorWait(MonitorWaitEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("MonitorWaitEvent");
    }

    @Override
    public DebugStatus monitorWaited(MonitorWaitedEvent evt, JdiCause cause) {
        RmiTrace trace = this.cmds.state.trace;
        if (trace == null) {
            return DebugStatus.NO_CHANGE;
        }
        this.onStop(evt, trace);
        return this.connector.getReturnStatus("MonitorWaitedEvent");
    }

    @Override
    public DebugStatus threadStateChanged(ThreadReference thread, Integer state, JdiCause cause, JdiReason reason) {
        return DebugStatus.NO_CHANGE;
    }

    void onStop(Event evt, RmiTrace trace) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        if (evt != null) {
            this.setCurrent(evt);
            vm = evt.virtualMachine();
        }
        VmState state = this.vmStates.get(vm);
        state.visited.clear();
        try (RmiBatch batch = this.hookState.batch();
             RmiTransaction tx = trace.openTx("Stopped");){
            state.recordState("Stopped");
            this.cmds.activate(null);
        }
    }

    private void setCurrent(Event event) {
        VirtualMachine eventVM = event.virtualMachine();
        JdiManagerImpl jdi = this.connector.getJdi();
        jdi.setCurrentEvent(event);
        jdi.setCurrentVM(eventVM);
        if (event instanceof LocatableEvent) {
            LocatableEvent locEvt = (LocatableEvent)event;
            jdi.setCurrentLocation(locEvt.location());
            ThreadReference eventThread = locEvt.thread();
            jdi.setCurrentThread(eventThread);
            try {
                jdi.setCurrentFrame(eventThread.frame(0));
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
        }
    }

    void onContinue() {
        VirtualMachine currentVM = this.connector.getJdi().getCurrentVM();
        VmState state = this.vmStates.get(currentVM);
        try (RmiBatch batch = this.hookState.batch();
             RmiTransaction tx = this.cmds.state.trace.openTx("Continue");){
            state.recordStateContinued(currentVM);
            this.cmds.activate(null);
        }
    }

    public void installHooks() {
        this.connector.getJdi().addEventsListener(null, this);
    }

    public void removeHooks() {
        this.connector.getJdi().removeEventsListener(null, this);
    }

    public void enableCurrentVM() {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        VmState state = new VmState(this.connector);
        this.vmStates.put(vm, state);
        state.recordState("VM started");
        this.cmds.activate(null);
    }

    public void disableCurrentVM() {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        VmState state = this.vmStates.get(vm);
        state.visited.clear();
        this.vmStates.remove(vm);
        vm.dispose();
    }

    public void setState(VirtualMachine vm) {
        VmState state = this.vmStates.get(vm);
        state.setState(vm);
    }
}

