/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.ImmutableValueBox;
import ghidra.trace.database.target.ValueBox;
import ghidra.trace.database.target.ValueShape;
import ghidra.trace.database.target.ValueTriple;
import ghidra.trace.model.Lifespan;
import ghidra.util.database.DBCachedObjectStoreFactory;

public record ImmutableValueShape(DBTraceObject parent, DBTraceObject child, String entryKey, Lifespan lifespan, int addressSpaceId, long minAddressOffset, long maxAddressOffset) implements ValueShape
{
    public ImmutableValueShape(DBTraceObject parent, Object value, String entryKey, Lifespan lifespan) {
        this(parent, value instanceof DBTraceObject ? (child = (DBTraceObject)value) : null, entryKey, lifespan, ImmutableValueShape.getAddressSpaceId(value), ImmutableValueShape.getMinAddressOffset(value), ImmutableValueShape.getMaxAddressOffset(value));
        DBTraceObject child;
    }

    public ImmutableValueShape(ValueShape shape) {
        this(shape.getParent(), shape.getChildOrNull(), shape.getEntryKey(), shape.getLifespan(), shape.getAddressSpaceId(), shape.getMinAddressOffset(), shape.getMaxAddressOffset());
    }

    public static int getAddressSpaceId(Object value) {
        if (value instanceof Address) {
            Address address = (Address)value;
            return address.getAddressSpace().getSpaceID();
        }
        if (value instanceof AddressRange) {
            AddressRange range = (AddressRange)value;
            return range.getAddressSpace().getSpaceID();
        }
        return -1;
    }

    public static long getMinAddressOffset(Object value) {
        if (value instanceof Address) {
            Address address = (Address)value;
            return address.getOffset();
        }
        if (value instanceof AddressRange) {
            AddressRange range = (AddressRange)value;
            return range.getMinAddress().getOffset();
        }
        return 0L;
    }

    public static long getMaxAddressOffset(Object value) {
        if (value instanceof Address) {
            Address address = (Address)value;
            return address.getOffset();
        }
        if (value instanceof AddressRange) {
            AddressRange range = (AddressRange)value;
            return range.getMaxAddress().getOffset();
        }
        return 0L;
    }

    public ValueBox getBounds() {
        long parentKey = this.parent == null ? -1L : this.parent.getKey();
        long childKey = this.child == null ? -1L : this.child.getKey();
        return new ImmutableValueBox(new ValueTriple(parentKey, childKey, this.entryKey, this.lifespan.lmin(), new DBCachedObjectStoreFactory.RecAddress(this.addressSpaceId, this.minAddressOffset)), new ValueTriple(parentKey, childKey, this.entryKey, this.lifespan.lmax(), new DBCachedObjectStoreFactory.RecAddress(this.addressSpaceId, this.maxAddressOffset)));
    }

    public String description() {
        return this.toString();
    }

    @Override
    public DBTraceObject getParent() {
        return this.parent;
    }

    @Override
    public DBTraceObject getChild() {
        return this.child;
    }

    @Override
    public DBTraceObject getChildOrNull() {
        return this.child;
    }

    @Override
    public String getEntryKey() {
        return this.entryKey;
    }

    @Override
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    @Override
    public int getAddressSpaceId() {
        return this.addressSpaceId;
    }

    @Override
    public long getMinAddressOffset() {
        return this.minAddressOffset;
    }

    @Override
    public long getMaxAddressOffset() {
        return this.maxAddressOffset;
    }
}

