/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcode;

import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.app.util.pcode.Appender;
import ghidra.app.util.pcode.PcodeFormatter;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.util.Msg;
import java.util.List;

public abstract class AbstractPcodeFormatter<T, A extends Appender<T>>
implements PcodeFormatter<T> {
    protected abstract A createAppender(Language var1, boolean var2);

    protected boolean isFormatRaw() {
        return false;
    }

    @Override
    public T formatTemplates(Language language, List<OpTpl> pcodeOpTemplates) {
        boolean indent = AbstractPcodeFormatter.hasLabel(pcodeOpTemplates);
        A appender = this.createAppender(language, indent);
        for (OpTpl template : pcodeOpTemplates) {
            if (FormatResult.TERMINATE == this.formatOpTemplate(appender, template)) break;
        }
        return appender.finish();
    }

    protected FormatResult formatOpTemplate(A appender, OpTpl op) {
        int opcode = op.getOpcode();
        if (65 == opcode) {
            appender.appendLineLabel(op.getInput()[0].getOffset().getReal());
            return FormatResult.CONTINUE;
        }
        appender.appendIndent();
        if (opcode >= 74) {
            throw new RuntimeException("Unsupported opcode encountered: " + opcode);
        }
        VarnodeTpl output = op.getOutput();
        if (output != null) {
            this.formatOutput(appender, opcode, output);
            appender.appendCharacter('=');
        }
        appender.appendMnemonic(opcode);
        VarnodeTpl[] inputs = op.getInput();
        for (int i = 0; i < inputs.length; ++i) {
            if (i > 0) {
                appender.appendCharacter(',');
            }
            appender.appendCharacter(' ');
            if (i == 0) {
                if (!this.isFormatRaw()) {
                    if (opcode == 2 || opcode == 3) {
                        this.formatMemoryInput(appender, inputs[0], inputs[1]);
                        ++i;
                        continue;
                    }
                    if (opcode == 9) {
                        this.formatCallOtherName(appender, inputs[0]);
                        continue;
                    }
                }
                if ((opcode == 4 || opcode == 5) && this.formatLabelInput(appender, inputs[i])) continue;
            }
            this.formatInput(appender, opcode, i, inputs[i]);
        }
        return FormatResult.CONTINUE;
    }

    protected void formatOutput(A appender, int opcode, VarnodeTpl output) {
        this.formatVarnode(appender, opcode, -1, output);
    }

    protected void formatInput(A appender, int opcode, int opIndex, VarnodeTpl input) {
        this.formatVarnode(appender, opcode, opIndex, input);
    }

    protected void formatVarnode(A appender, int opcode, int opIndex, VarnodeTpl vTpl) {
        ConstTpl space = vTpl.getSpace();
        ConstTpl offset = vTpl.getOffset();
        ConstTpl size = vTpl.getSize();
        if (space.getType() == 5) {
            if (offset.getType() == 2) {
                appender.appendLabel("inst_start");
            } else if (offset.getType() == 3) {
                appender.appendLabel("inst_next");
            } else if (offset.getType() == 4) {
                appender.appendLabel("inst_next2");
            } else {
                this.formatAddress(appender, null, offset, size);
            }
        } else if (space.getType() == 7) {
            if (this.isFormatRaw() && offset.getType() == 0 && size.getType() == 0) {
                this.formatVarnodeRaw(appender, space.getSpaceId(), offset, size);
            } else {
                this.formatVarnodeNice(appender, space.getSpaceId(), offset, size);
            }
        } else {
            throw new RuntimeException("Unsupported space template type: " + space.getType());
        }
    }

    protected void formatVarnodeNice(A appender, AddressSpace space, ConstTpl offset, ConstTpl size) {
        if (space.isConstantSpace()) {
            this.formatConstant(appender, offset, size);
        } else if (space.isUniqueSpace()) {
            this.formatUnique(appender, offset, size);
        } else {
            this.formatAddress(appender, space, offset, size);
        }
    }

    protected void formatVarnodeRaw(A appender, AddressSpace space, ConstTpl offset, ConstTpl size) {
        appender.appendRawVarnode(space, offset.getReal(), size.getReal());
    }

    protected void formatUnique(A appender, ConstTpl offset, ConstTpl size) {
        if (offset.getType() != 0) {
            throw new RuntimeException("Unsupported unique offset type: " + offset.getType());
        }
        if (size.getType() != 0) {
            throw new RuntimeException("Unsupported unique size type: " + size.getType());
        }
        appender.appendUnique(offset.getReal());
        this.formatSize(appender, size);
    }

    protected void formatAddress(A appender, AddressSpace addrSpace, ConstTpl offset, ConstTpl size) {
        if (offset.getType() != 0) {
            throw new RuntimeException("Unsupported address offset type: " + offset.getType());
        }
        long offsetValue = offset.getReal();
        if (addrSpace == null) {
            appender.appendCharacter('*');
            appender.appendAddressWordOffcut(offsetValue, 0L);
            if (size.getType() != 6) {
                this.formatSize(appender, size);
            }
            return;
        }
        long sizeValue = size.getReal();
        Register reg = appender.getLanguage().getRegister(addrSpace.getAddress(offsetValue), (int)sizeValue);
        if (reg != null) {
            appender.appendRegister(reg);
            if ((long)reg.getMinimumByteSize() > sizeValue) {
                appender.appendCharacter(':');
                appender.appendScalar(sizeValue);
            }
            return;
        }
        appender.appendCharacter('*');
        appender.appendCharacter('[');
        appender.appendSpace(addrSpace);
        appender.appendCharacter(']');
        long wordOffset = offsetValue / (long)addrSpace.getAddressableUnitSize();
        long offcut = offsetValue % (long)addrSpace.getAddressableUnitSize();
        appender.appendAddressWordOffcut(wordOffset, offcut);
        this.formatSize(appender, size);
    }

    protected void formatConstant(A appender, ConstTpl offset, ConstTpl size) {
        if (offset.getType() != 0) {
            throw new RuntimeException("Unsupported constant offset type: " + offset.getType());
        }
        long value = offset.getReal();
        appender.appendScalar(value);
        this.formatSize(appender, size);
    }

    protected void formatSize(A appender, ConstTpl size) {
        if (size.getType() != 0) {
            throw new RuntimeException("Unsupported address size type: " + size.getType());
        }
        if (size.getReal() != 0L) {
            appender.appendCharacter(':');
            appender.appendScalar(size.getReal());
        }
    }

    protected void formatCallOtherName(A appender, VarnodeTpl input0) {
        if (!input0.getSpace().isConstSpace() || input0.getOffset().getType() != 0) {
            throw new RuntimeException("Expected constant input[0] for CALLOTHER pcode op");
        }
        int id = (int)input0.getOffset().getReal();
        appender.appendCharacter('\"');
        appender.appendUserop(id);
        appender.appendCharacter('\"');
    }

    protected boolean formatLabelInput(A appender, VarnodeTpl input0) {
        if (input0.getSpace().isConstSpace() && input0.getOffset().getType() == 8) {
            appender.appendLineLabelRef(input0.getOffset().getReal());
            return true;
        }
        return false;
    }

    protected void formatMemoryInput(A appender, VarnodeTpl input0, VarnodeTpl input1) {
        if (!input0.getSpace().isConstSpace() || input0.getOffset().getType() != 0) {
            throw new RuntimeException("Expected constant input[0] for LOAD/STORE pcode op");
        }
        int id = (int)input0.getOffset().getReal();
        AddressSpace space = appender.getLanguage().getAddressFactory().getAddressSpace(id);
        if (space == null) {
            Msg.error((Object)this, (Object)("Address space id not found: " + id));
        }
        appender.appendSpace(space);
        appender.appendCharacter('(');
        this.formatVarnode(appender, -1, 0, input1);
        appender.appendCharacter(')');
    }

    private static boolean hasLabel(List<OpTpl> pcodeOpTemplates) {
        for (OpTpl op : pcodeOpTemplates) {
            if (!AbstractPcodeFormatter.isLineLabel(op)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isLineLabel(OpTpl template) {
        return template.getOpcode() == 65;
    }

    protected static enum FormatResult {
        CONTINUE,
        TERMINATE;

    }
}

