/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface AddressSetView
extends Iterable<AddressRange> {
    public boolean contains(Address var1);

    public boolean contains(Address var1, Address var2);

    public boolean contains(AddressSetView var1);

    public boolean isEmpty();

    public Address getMinAddress();

    public Address getMaxAddress();

    public int getNumAddressRanges();

    public AddressRangeIterator getAddressRanges();

    public AddressRangeIterator getAddressRanges(boolean var1);

    public AddressRangeIterator getAddressRanges(Address var1, boolean var2);

    @Override
    public Iterator<AddressRange> iterator();

    @Override
    default public Spliterator<AddressRange> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.getNumAddressRanges(), 341);
    }

    default public Stream<AddressRange> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Iterator<AddressRange> iterator(boolean var1);

    default public Spliterator<AddressRange> spliterator(boolean forward) {
        return Spliterators.spliterator(this.iterator(forward), (long)this.getNumAddressRanges(), 341);
    }

    default public Stream<AddressRange> stream(boolean forward) {
        return StreamSupport.stream(this.spliterator(forward), false);
    }

    public Iterator<AddressRange> iterator(Address var1, boolean var2);

    default public Spliterator<AddressRange> spliterator(Address start, boolean forward) {
        return Spliterators.spliterator(this.iterator(start, forward), (long)this.getNumAddressRanges(), 341);
    }

    default public Stream<AddressRange> stream(Address start, boolean forward) {
        return StreamSupport.stream(this.spliterator(start, forward), false);
    }

    public long getNumAddresses();

    public AddressIterator getAddresses(boolean var1);

    public AddressIterator getAddresses(Address var1, boolean var2);

    public boolean intersects(AddressSetView var1);

    public boolean intersects(Address var1, Address var2);

    public AddressSet intersect(AddressSetView var1);

    public AddressSet intersectRange(Address var1, Address var2);

    public AddressSet union(AddressSetView var1);

    public AddressSet subtract(AddressSetView var1);

    public AddressSet xor(AddressSetView var1);

    public boolean hasSameAddresses(AddressSetView var1);

    public AddressRange getFirstRange();

    public AddressRange getLastRange();

    public AddressRange getRangeContaining(Address var1);

    public Address findFirstAddressInCommon(AddressSetView var1);

    default public long getAddressCountBefore(Address address) {
        long count = 0L;
        for (AddressRange range : this.getAddressRanges()) {
            if (range.getMinAddress().compareTo(address) > 0) {
                return count;
            }
            if (range.contains(address)) {
                return count += address.subtract(range.getMinAddress());
            }
            count += range.getLength();
        }
        return count;
    }

    public static AddressSetView trimStart(AddressSetView set, Address addr) {
        AddressSet trimmedSet = new AddressSet();
        AddressRangeIterator addressRanges = set.getAddressRanges();
        while (addressRanges.hasNext()) {
            AddressRange range = (AddressRange)addressRanges.next();
            Address rangeMin = range.getMinAddress();
            Address rangeMax = range.getMaxAddress();
            if (rangeMin.compareTo(addr) > 0) {
                trimmedSet.add(range);
                continue;
            }
            if (rangeMax.compareTo(addr) <= 0) continue;
            trimmedSet.add(addr.next(), rangeMax);
        }
        return trimmedSet;
    }

    public static AddressSetView trimEnd(AddressSetView set, Address addr) {
        AddressSet trimmedSet = new AddressSet();
        AddressRangeIterator addressRanges = set.getAddressRanges();
        while (addressRanges.hasNext()) {
            AddressRange range = (AddressRange)addressRanges.next();
            Address rangeMin = range.getMinAddress();
            Address rangeMax = range.getMaxAddress();
            if (rangeMax.compareTo(addr) < 0) {
                trimmedSet.add(range);
                continue;
            }
            if (rangeMin.compareTo(addr) >= 0) continue;
            trimmedSet.add(rangeMin, addr.previous());
        }
        return trimmedSet;
    }
}

