/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jgrapht.Graph;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.decorators.ExpandXY;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEdgeRenderer<V, E>
implements Renderer.Edge<V, E> {
    private static final Logger log = LoggerFactory.getLogger(AbstractEdgeRenderer.class);

    @Override
    public void paintEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        GraphicsDecorator g2d = renderContext.getGraphicsContext();
        if (!renderContext.getEdgeIncludePredicate().test(e)) {
            return;
        }
        Object u = layoutModel.getGraph().getEdgeSource(e);
        Object v = layoutModel.getGraph().getEdgeTarget(e);
        Predicate<V> vertexIncludePredicate = renderContext.getVertexIncludePredicate();
        if (!vertexIncludePredicate.test(u) || !vertexIncludePredicate.test(v)) {
            return;
        }
        Stroke newStroke = renderContext.getSelectedEdgeState().isSelected(e) ? renderContext.getSelectedEdgeStrokeFunction().apply(e) : renderContext.getEdgeStrokeFunction().apply(e);
        Stroke oldStroke = g2d.getStroke();
        if (newStroke != null) {
            g2d.setStroke(newStroke);
        }
        this.drawSimpleEdge(renderContext, layoutModel, e);
        g2d.setStroke(oldStroke);
    }

    protected Shape prepareFinalEdgeShape(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e, int[] coords, boolean[] loop) {
        Object source = layoutModel.getGraph().getEdgeSource(e);
        Object target = layoutModel.getGraph().getEdgeTarget(e);
        Point sourcePoint = (Point)layoutModel.apply(source);
        Point targetPoint = (Point)layoutModel.apply(target);
        Point2D sourcePoint2D = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(sourcePoint.x, sourcePoint.y));
        Point2D targetPoint2D = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(targetPoint.x, targetPoint.y));
        float sourcePoint2DX = (float)sourcePoint2D.getX();
        float sourcePoint2DY = (float)sourcePoint2D.getY();
        float targetPoint2DX = (float)targetPoint2D.getX();
        float targetPoint2DY = (float)targetPoint2D.getY();
        coords[0] = (int)sourcePoint2DX;
        coords[1] = (int)sourcePoint2DY;
        coords[2] = (int)targetPoint2DX;
        coords[3] = (int)targetPoint2DY;
        boolean isLoop = loop[0] = source.equals(target);
        Shape targetShape = renderContext.getVertexShapeFunction().apply(target);
        Shape edgeShape = this.getEdgeShape(renderContext.getEdgeShapeFunction(), e, layoutModel.getGraph());
        AffineTransform xform = AffineTransform.getTranslateInstance(sourcePoint2DX, sourcePoint2DY);
        if (isLoop) {
            Rectangle2D targetShapeBounds2D = targetShape.getBounds2D();
            xform.scale(targetShapeBounds2D.getWidth(), targetShapeBounds2D.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else {
            float dx = targetPoint2DX - sourcePoint2DX;
            float dy = targetPoint2DY - sourcePoint2DY;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            double dist = Math.sqrt(dx * dx + dy * dy);
            if (edgeShape instanceof ExpandXY) {
                MutableTransformer layoutTransformer = renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
                double scaleX = layoutTransformer.getScaleX();
                double scaleY = layoutTransformer.getScaleY();
                AffineTransform singleAxisScalingTransform = AffineTransform.getScaleInstance(1.0, scaleX / scaleY);
                log.trace("scaleX: {} ", (Object)scaleX);
                log.trace("scaleY: {}", (Object)scaleY);
                edgeShape = singleAxisScalingTransform.createTransformedShape(edgeShape);
                xform.scale(dist, dist);
            } else {
                xform.scale(dist, 1.0);
            }
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        return edgeShape;
    }

    protected abstract Shape getEdgeShape(BiFunction<Graph<V, E>, E, Shape> var1, E var2, Graph<V, E> var3);

    protected abstract void drawSimpleEdge(RenderContext<V, E> var1, LayoutModel<V> var2, E var3);
}

