/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.transform;

import java.awt.Dimension;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Optional;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.PolarPoint;
import org.jungrapht.visualization.transform.Intersections;
import org.jungrapht.visualization.transform.Lens;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.MutableAffineTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperbolicTransformer
extends LensTransformer
implements MutableTransformer {
    private static final Logger log = LoggerFactory.getLogger(HyperbolicTransformer.class);

    public static <T extends HyperbolicTransformer> Builder<T, ?> builder(Lens lens) {
        return new Builder(lens);
    }

    public static <T extends HyperbolicTransformer> Builder<T, ?> builder(Dimension dimension) {
        return new Builder(dimension);
    }

    protected HyperbolicTransformer(Builder builder) {
        this(builder.lens, builder.delegate);
    }

    protected HyperbolicTransformer(Dimension d) {
        this(d, (MutableTransformer)new MutableAffineTransformer());
    }

    protected HyperbolicTransformer(Dimension d, MutableTransformer delegate) {
        super(d, delegate);
    }

    protected HyperbolicTransformer(Lens lens, MutableTransformer delegate) {
        super(lens, delegate);
    }

    @Override
    public Point2D transform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D lensCenterInLayoutCoordinates = this.lens.getCenter();
        RectangularShape lensShape = this.lens.getLensShape();
        double centerToCorner = this.lens.getCenterToCorner();
        double ratio = this.lens.getRatio();
        Point2D viewPoint = this.delegate.transform(graphPoint);
        double dx = viewPoint.getX() - lensCenterInLayoutCoordinates.getX();
        double dy = viewPoint.getY() - lensCenterInLayoutCoordinates.getY();
        Point pointFromCenter = Point.of((double)(dx *= ratio), (double)dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point)pointFromCenter);
        double polarPointAngle = polar.theta;
        double polarPointRadius = polar.radius;
        if (!lensShape.contains(viewPoint)) {
            return viewPoint;
        }
        double mag = Math.tan(1.5707963267948966 * (double)this.lens.getMagnification());
        polarPointRadius *= mag;
        polarPointRadius = Math.min(polarPointRadius, centerToCorner);
        polarPointRadius /= centerToCorner;
        polarPointRadius *= 1.5707963267948966;
        polarPointRadius = Math.abs(Math.atan(polarPointRadius));
        polarPointRadius *= centerToCorner;
        polarPointRadius = Math.min(polarPointRadius, centerToCorner);
        if (lensShape instanceof Ellipse2D) {
            double lensRadius = this.lens.getRadius();
            polarPointRadius = Math.min(polarPointRadius, lensRadius);
        } else if (lensShape instanceof Rectangle2D) {
            Rectangle2D lensRectangle;
            Point projectedPoint = PolarPoint.polarToCartesian((double)polarPointAngle, (double)polarPointRadius);
            Line2D.Double vector = new Line2D.Double(lensCenterInLayoutCoordinates.getX(), lensCenterInLayoutCoordinates.getY(), lensCenterInLayoutCoordinates.getX() + projectedPoint.x, lensCenterInLayoutCoordinates.getY() + projectedPoint.y);
            Optional<Point2D> intersectionPointOptional = Intersections.getIntersectionPoint((Line2D)vector, lensRectangle = (Rectangle2D)this.lens.getLensShape());
            if (intersectionPointOptional.isPresent()) {
                Point2D intersectionPoint = intersectionPointOptional.get();
                polarPointRadius = lensCenterInLayoutCoordinates.distance(intersectionPoint);
            }
        }
        Point projectedPoint = PolarPoint.polarToCartesian((double)polarPointAngle, (double)polarPointRadius);
        projectedPoint = Point.of((double)(projectedPoint.x / ratio), (double)projectedPoint.y);
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.x + lensCenterInLayoutCoordinates.getX(), projectedPoint.y + lensCenterInLayoutCoordinates.getY());
        return translatedBack;
    }

    @Override
    public Point2D inverseTransform(Point2D viewPoint) {
        Point2D lensCenterInLayoutCoords = this.lens.getCenter();
        double viewRadius = this.lens.getRadius();
        double ratio = this.lens.getRatio();
        double dx = viewPoint.getX() - lensCenterInLayoutCoords.getX();
        double dy = viewPoint.getY() - lensCenterInLayoutCoords.getY();
        Point pointFromCenter = Point.of((double)(dx *= ratio), (double)dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point)pointFromCenter);
        double radius = polar.radius;
        RectangularShape lensShape = this.lens.getLensShape();
        if (!lensShape.contains(viewPoint)) {
            return this.delegate.inverseTransform(viewPoint);
        }
        radius /= viewRadius;
        radius = Math.abs(Math.tan(radius));
        radius /= 1.5707963267948966;
        radius *= viewRadius;
        double mag = Math.tan(1.5707963267948966 * (double)this.lens.getMagnification());
        polar = polar.newRadius(radius /= mag);
        Point projectedPoint = PolarPoint.polarToCartesian((PolarPoint)polar);
        projectedPoint = Point.of((double)(projectedPoint.x / ratio), (double)projectedPoint.y);
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.x + lensCenterInLayoutCoords.getX(), projectedPoint.y + lensCenterInLayoutCoords.getY());
        return this.delegate.inverseTransform(translatedBack);
    }

    public static class Builder<T extends HyperbolicTransformer, B extends Builder<T, B>>
    extends LensTransformer.Builder<T, B> {
        public Builder(Lens lens) {
            super(lens);
        }

        public Builder(Dimension dimension) {
            super(dimension);
        }

        @Override
        public T build() {
            if (this.lens == null && this.dimension != null) {
                this.lens = new Lens();
            }
            return (T)new HyperbolicTransformer(this);
        }
    }
}

