/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.pcode;

import ghidra.app.plugin.core.debug.gui.pcode.PcodeRow;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.PcodeOp;
import java.util.Objects;

public class OpPcodeRow
implements PcodeRow {
    protected final Language language;
    protected final PcodeOp op;
    protected final boolean isNext;
    protected final String label;
    protected final String code;

    public OpPcodeRow(Language language, PcodeOp op, boolean isNext, String label, String code) {
        this.language = language;
        this.op = Objects.requireNonNull(op);
        this.isNext = isNext;
        this.label = label;
        this.code = code;
    }

    @Override
    public int getSequence() {
        return this.op.getSeqnum().getTime();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public boolean isNext() {
        return this.isNext;
    }

    @Override
    public PcodeOp getOp() {
        return this.op;
    }
}

