/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog.problems;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemDefinition;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NonNull;

public class DefaultCatalogProblemBuilder {
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    public static final String VERSION_CATALOG_PROBLEMS = "version_catalog_problems";

    public static void maybeThrowError(InternalProblems problemsService, String error, Collection<InternalProblem> problems) {
        if (!problems.isEmpty()) {
            throw DefaultCatalogProblemBuilder.throwError(problemsService, error, problems);
        }
    }

    public static RuntimeException throwError(InternalProblems problemsService, String error, Collection<InternalProblem> problems) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(error);
        formatter.startChildren();
        for (InternalProblem problem : problems) {
            formatter.node(DefaultCatalogProblemBuilder.getProblemString(problem));
            problemsService.getInternalReporter().report((Problem)problem);
        }
        formatter.endChildren();
        throw new InvalidUserDataException(formatter.toString());
    }

    public static String getProblemString(InternalProblem problem) {
        ProblemDefinition definition = problem.getDefinition();
        String contextualLabel = problem.getContextualLabel();
        String renderedLabel = contextualLabel == null ? definition.getId().getDisplayName() : contextualLabel;
        return DefaultCatalogProblemBuilder.getProblemString(renderedLabel, problem.getDetails(), problem.getSolutions(), definition.getDocumentationLink());
    }

    public static String getProblemString(String label, String details, List<String> solutions, DocLink documentationLink) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(label);
        if (details != null) {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize((String)TextUtil.endLineWithDot((String)details)));
        }
        TypeValidationProblemRenderer.renderSolutions((TreeFormatter)formatter, solutions);
        if (documentationLink != null) {
            formatter.blankLine();
            formatter.node(DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("information", documentationLink));
        }
        return formatter.toString();
    }

    public static @NonNull String getProblemInVersionCatalog(VersionCatalogBuilder builder) {
        return DefaultCatalogProblemBuilder.getProblemInVersionCatalog(builder.getName());
    }

    public static @NonNull String getProblemInVersionCatalog(String name) {
        return "Problem: " + DefaultCatalogProblemBuilder.getInVersionCatalog(name);
    }

    public static @NonNull String getInVersionCatalog(String name) {
        return "In version catalog " + name;
    }
}

