/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.UriUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001a.\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\bH\u0007\u001a(\u0010\r\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007\u001a\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "canonicalizePath", "", "url", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "", "isValidPath", "path", "canonicalizeUrl", "transformToLocalFileUrlIfPossible", "doCanonicalize", "asLocalFileIfAbsoluteAndExists", "pathExistsSafe", "intellij.platform.scriptDebugger.backend"})
@SourceDebugExtension(value={"SMAP\nSourceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceResolver.kt\norg/jetbrains/debugger/sourcemap/SourceResolverKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,207:1\n13#2:208\n*S KotlinDebug\n*F\n+ 1 SourceResolver.kt\norg/jetbrains/debugger/sourcemap/SourceResolverKt\n*L\n23#1:208\n*E\n"})
public final class SourceResolverKt {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    @NotNull
    public static final String canonicalizePath(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Object path = UriUtil.trimParameters((String)url);
        if (!FileUtil.isAbsolute((String)url) && ((CharSequence)url).length() > 0 && url.charAt(0) != '/') {
            String string = ScriptDebuggerUrls.INSTANCE.toFilePath(baseUrl);
            if (string == null) {
                String string2 = baseUrl.getPath();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            }
            String basePath = string;
            if (baseUrlIsFile) {
                int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)basePath, (char)'/', (int)0, (boolean)false, (int)6, null);
                StringBuilder pathBuilder = new StringBuilder();
                StringBuilder stringBuilder = lastSlashIndex == -1 ? pathBuilder.append('/') : pathBuilder.append(basePath, 0, lastSlashIndex + 1);
                path = pathBuilder.append(url).toString();
                boolean resolveSymlinks = SourceResolverKt.isValidPath((String)path);
                String string3 = FileUtil.toCanonicalPath((String)path, (boolean)resolveSymlinks);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toCanonicalPath(...)");
                return string3;
            }
            path = basePath + "/" + url;
        }
        String string = FileUtil.toCanonicalPath((String)path, (char)'/');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCanonicalPath(...)");
        return string;
    }

    private static final boolean isValidPath(String path) {
        boolean bl;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(path, new String[0]), (String)"get(...)");
            bl = true;
        }
        catch (InvalidPathException invalidPathException) {
            bl = false;
        }
        return bl;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl, boolean baseUrlIsFile, boolean transformToLocalFileUrlIfPossible) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null)) {
            return ScriptDebuggerUrls.INSTANCE.toLocalFileUrl(url);
        }
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"data:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"blob:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"javascript:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"webpack:", (boolean)false, (int)2, null)) {
            Url url2 = Urls.parseEncoded((String)url);
            if (url2 == null) {
                url2 = Urls.newUri(null, (String)url);
            }
            return url2;
        }
        return SourceResolverKt.doCanonicalize(url, baseUrl, baseUrlIsFile, transformToLocalFileUrlIfPossible);
    }

    public static /* synthetic */ Url canonicalizeUrl$default(String string, Url url, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return SourceResolverKt.canonicalizeUrl(string, url, bl, bl2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final Url doCanonicalize(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile, boolean asLocalFileIfAbsoluteAndExists) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        String path = SourceResolverKt.canonicalizePath(url, baseUrl, baseUrlIsFile);
        if (baseUrl.isInLocalFileSystem() || asLocalFileIfAbsoluteAndExists && SourceResolver.Companion.isAbsolute(path) && SourceResolverKt.pathExistsSafe(path)) {
            return ScriptDebuggerUrls.newLocalFileUrl(path);
        }
        if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            Url url2 = ScriptDebuggerUrls.parse(path, true);
            if (url2 == null) {
                url2 = Urls.newUnparsable((String)path);
            }
            return url2;
        }
        char[] cArray = new char[]{'?'};
        List split = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        String string2 = baseUrl.getScheme();
        String string3 = baseUrl.getAuthority();
        String string4 = (String)split.get(0);
        if (split.size() > 1) {
            char c = '?';
            String string5 = (String)split.get(1);
            string = c + string5;
        } else {
            string = null;
        }
        return Urls.newUrl((String)string2, (String)string3, (String)string4, string);
    }

    private static final boolean pathExistsSafe(String path) {
        boolean bl;
        try {
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }
        catch (InvalidPathException e) {
            LOG.warn("Invalid path: " + path, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SourceResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

