/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;

public class GrAnnotationStub
extends StubBase<GrAnnotation> {
    private static final Logger LOG = Logger.getInstance(GrAnnotationStub.class);
    private final String myText;
    private volatile java.lang.ref.SoftReference<GrAnnotation> myPsiRef;

    public GrAnnotationStub(StubElement parent, String text) {
        super(parent, (IStubElementType)GroovyStubElementTypes.ANNOTATION);
        this.myText = text;
    }

    public GrAnnotationStub(StubElement parent, GrAnnotation from) {
        super(parent, (IStubElementType)GroovyStubElementTypes.ANNOTATION);
        this.myText = from.getText();
    }

    public GrAnnotation getPsiElement() {
        GrAnnotation annotation = (GrAnnotation)SoftReference.dereference(this.myPsiRef);
        if (annotation != null) {
            return annotation;
        }
        try {
            annotation = GroovyPsiElementFactory.getInstance(this.getProject()).createAnnotationFromText(this.myText, this.getPsi());
            this.myPsiRef = new java.lang.ref.SoftReference<GrAnnotation>(annotation);
            return annotation;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in repository!", (Throwable)e);
            return null;
        }
    }

    public String getText() {
        return this.myText;
    }
}

