/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b'\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue;", "Lcom/intellij/build/issue/BuildIssue;", "dependencyName", "", "dependencyOwner", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "title", "getTitle", "()Ljava/lang/String;", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "buildDescription", "failureMessage", "isOfflineMode", "", "offlineModeQuickFixText", "Companion", "intellij.gradle"})
@ApiStatus.Internal
public abstract class UnresolvedDependencyIssue
implements BuildIssue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String dependencyOwner;
    @NotNull
    private final String title;
    @NotNull
    public static final String offlineQuickFixId = "disable_offline_mode";
    @NotNull
    private static final String declaringRepositoriesLink = "https://docs.gradle.org/current/userguide/declaring_repositories.html";

    public UnresolvedDependencyIssue(@NotNull String dependencyName, @Nullable String dependencyOwner) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        this.dependencyOwner = dependencyOwner;
        this.title = "Could not resolve " + dependencyName + (String)(this.dependencyOwner != null ? " for " + this.dependencyOwner : "");
    }

    public /* synthetic */ UnresolvedDependencyIssue(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @NotNull
    public final String buildDescription(@Nullable String failureMessage, boolean isOfflineMode, @NotNull String offlineModeQuickFixText) {
        Intrinsics.checkNotNullParameter((Object)offlineModeQuickFixText, (String)"offlineModeQuickFixText");
        StringBuilder issueDescription = new StringBuilder();
        if (this.dependencyOwner != null) {
            issueDescription.append(this.dependencyOwner);
            issueDescription.append(": ");
        }
        String string = failureMessage;
        issueDescription.append(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null);
        String string2 = failureMessage;
        boolean noRepositoriesDefined = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"no repositories are defined", (boolean)false, (int)2, null) : false;
        issueDescription.append("\n\nPossible solution:\n");
        StringBuilder stringBuilder = isOfflineMode && !noRepositoriesDefined ? issueDescription.append(" - <a href=\"disable_offline_mode\">" + offlineModeQuickFixText + "</a>\n") : issueDescription.append(" - Declare repository providing the artifact, see the documentation at https://docs.gradle.org/current/userguide/declaring_repositories.html\n");
        String string3 = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue$Companion;", "", "<init>", "()V", "offlineQuickFixId", "", "declaringRepositoriesLink", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

