/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.HashUtil;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.hashing.XXH3Base;
import com.dynatrace.hash4j.internal.ByteArrayUtil;

final class XXH3_64
extends XXH3Base {
    private final long bitflip12;
    private final long bitflip34;
    private final long bitflip56;
    private final long hash0;
    private static final Hasher64 DEFAULT_HASHER_INSTANCE = new XXH3_64();

    private XXH3_64(long seed) {
        super(seed, false);
        this.bitflip12 = -4090762196417718878L - (seed ^ Long.reverseBytes(seed & 0xFFFFFFFFL));
        this.bitflip34 = 7458650908927343033L + seed;
        this.bitflip56 = -5812251307325107654L - seed;
        this.hash0 = XXH3_64.avalanche64(seed ^ 0x8726F9105DC21DDCL);
    }

    private XXH3_64() {
        this(0L);
    }

    public static Hasher64 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    public static Hasher64 create(long seed) {
        return new XXH3_64(seed);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    private static long rrmxmx(long h64, long length) {
        h64 ^= Long.rotateLeft(h64, 49) ^ Long.rotateLeft(h64, 24);
        h64 *= -6939452855193903323L;
        h64 ^= (h64 >>> 35) + length;
        return (h64 *= -6939452855193903323L) ^ h64 >>> 28;
    }

    private static long mix16B(byte[] input, int offIn, long[] sec, int offSec) {
        long lo = ByteArrayUtil.getLong(input, offIn);
        long hi = ByteArrayUtil.getLong(input, offIn + 8);
        return HashUtil.mix(lo ^ sec[offSec], hi ^ sec[offSec + 1]);
    }

    private static <T> long mix16B(T input, long offIn, long[] sec, int offSec, ByteAccess<T> access) {
        long lo = access.getLong(input, offIn);
        long hi = access.getLong(input, offIn + 8L);
        return HashUtil.mix(lo ^ sec[offSec], hi ^ sec[offSec + 1]);
    }

    private static long mix16B(CharSequence input, int offIn, long[] sec, int offSec) {
        long lo = ByteArrayUtil.getLong(input, offIn);
        long hi = ByteArrayUtil.getLong(input, offIn + 4);
        return HashUtil.mix(lo ^ sec[offSec], hi ^ sec[offSec + 1]);
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int length) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int offStripe;
        int s;
        int offBlock;
        if (length <= 16) {
            if (length > 8) {
                long lo = ByteArrayUtil.getLong(input, off) ^ this.bitflip34;
                long hi = ByteArrayUtil.getLong(input, off + length - 8) ^ this.bitflip56;
                long acc = (long)length + Long.reverseBytes(lo) + hi + HashUtil.mix(lo, hi);
                return XXH3_64.avalanche3(acc);
            }
            if (length >= 4) {
                long input1 = ByteArrayUtil.getInt(input, off);
                long input2 = (long)ByteArrayUtil.getInt(input, off + length - 4) & 0xFFFFFFFFL;
                long keyed = input2 ^ input1 << 32 ^ this.bitflip12;
                return XXH3_64.rrmxmx(keyed, length);
            }
            if (length != 0) {
                int c1 = input[off] & 0xFF;
                byte c2 = input[off + (length >> 1)];
                int c3 = input[off + length - 1] & 0xFF;
                long combined = (long)(c1 << 16 | c2 << 24 | c3 | length << 8) & 0xFFFFFFFFL;
                return XXH3_64.avalanche64(combined ^ this.bitflip00);
            }
            return this.hash0;
        }
        if (length <= 128) {
            long acc = (long)length * -7046029288634856825L;
            if (length > 32) {
                if (length > 64) {
                    if (length > 96) {
                        acc += XXH3_64.mix16B(input, off + 48, this.secret, 12);
                        acc += XXH3_64.mix16B(input, off + length - 64, this.secret, 14);
                    }
                    acc += XXH3_64.mix16B(input, off + 32, this.secret, 8);
                    acc += XXH3_64.mix16B(input, off + length - 48, this.secret, 10);
                }
                acc += XXH3_64.mix16B(input, off + 16, this.secret, 4);
                acc += XXH3_64.mix16B(input, off + length - 32, this.secret, 6);
            }
            acc += XXH3_64.mix16B(input, off, this.secret, 0);
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16, this.secret, 2));
        }
        if (length <= 240) {
            int i;
            long acc = (long)length * -7046029288634856825L;
            int nbRounds = length >>> 4;
            for (i = 0; i < 8; ++i) {
                acc += XXH3_64.mix16B(input, off + (i << 4), this.secret, i << 1);
            }
            acc = XXH3_64.avalanche3(acc);
            while (i < nbRounds) {
                acc += XXH3_64.mix16B(input, off + (i << 4), this.secShift, (i << 1) - 16);
                ++i;
            }
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16, this.secShift, 14));
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        int nbBlocks = length - 1 >>> 10;
        for (int n = 0; n < nbBlocks; ++n) {
            offBlock = off + (n << 10);
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (s << 6);
                b0 = ByteArrayUtil.getLong(input, offStripe + 0);
                b1 = ByteArrayUtil.getLong(input, offStripe + 8);
                b2 = ByteArrayUtil.getLong(input, offStripe + 16);
                b3 = ByteArrayUtil.getLong(input, offStripe + 24);
                b4 = ByteArrayUtil.getLong(input, offStripe + 32);
                b5 = ByteArrayUtil.getLong(input, offStripe + 40);
                b6 = ByteArrayUtil.getLong(input, offStripe + 48);
                b7 = ByteArrayUtil.getLong(input, offStripe + 56);
                acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
                acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_64.mixAcc(acc0, this.secret[16]);
            acc1 = XXH3_64.mixAcc(acc1, this.secret[17]);
            acc2 = XXH3_64.mixAcc(acc2, this.secret[18]);
            acc3 = XXH3_64.mixAcc(acc3, this.secret[19]);
            acc4 = XXH3_64.mixAcc(acc4, this.secret[20]);
            acc5 = XXH3_64.mixAcc(acc5, this.secret[21]);
            acc6 = XXH3_64.mixAcc(acc6, this.secret[22]);
            acc7 = XXH3_64.mixAcc(acc7, this.secret[23]);
        }
        int nbStripes = length - 1 - (nbBlocks << 10) >>> 6;
        offBlock = off + (nbBlocks << 10);
        for (s = 0; s < nbStripes; ++s) {
            offStripe = offBlock + (s << 6);
            b0 = ByteArrayUtil.getLong(input, offStripe + 0);
            b1 = ByteArrayUtil.getLong(input, offStripe + 8);
            b2 = ByteArrayUtil.getLong(input, offStripe + 16);
            b3 = ByteArrayUtil.getLong(input, offStripe + 24);
            b4 = ByteArrayUtil.getLong(input, offStripe + 32);
            b5 = ByteArrayUtil.getLong(input, offStripe + 40);
            b6 = ByteArrayUtil.getLong(input, offStripe + 48);
            b7 = ByteArrayUtil.getLong(input, offStripe + 56);
            acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
            acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
        }
        long result = (long)length * -7046029288634856825L;
        int offStripe2 = off + length - 64;
        long b02 = ByteArrayUtil.getLong(input, offStripe2 + 0);
        long b12 = ByteArrayUtil.getLong(input, offStripe2 + 8);
        long b22 = ByteArrayUtil.getLong(input, offStripe2 + 16);
        long b32 = ByteArrayUtil.getLong(input, offStripe2 + 24);
        long b42 = ByteArrayUtil.getLong(input, offStripe2 + 32);
        long b52 = ByteArrayUtil.getLong(input, offStripe2 + 40);
        long b62 = ByteArrayUtil.getLong(input, offStripe2 + 48);
        long b72 = ByteArrayUtil.getLong(input, offStripe2 + 56);
        result += HashUtil.mix((acc0 += b12 + XXH3_64.contrib(b02, this.secShiftFinalA0)) ^ this.secShiftFinalB0, (acc1 += b02 + XXH3_64.contrib(b12, this.secShiftFinalA1)) ^ this.secShiftFinalB1);
        result += HashUtil.mix((acc2 += b32 + XXH3_64.contrib(b22, this.secShiftFinalA2)) ^ this.secShiftFinalB2, (acc3 += b22 + XXH3_64.contrib(b32, this.secShiftFinalA3)) ^ this.secShiftFinalB3);
        result += HashUtil.mix((acc4 += b52 + XXH3_64.contrib(b42, this.secShiftFinalA4)) ^ this.secShiftFinalB4, (acc5 += b42 + XXH3_64.contrib(b52, this.secShiftFinalA5)) ^ this.secShiftFinalB5);
        return XXH3_64.avalanche3(result += HashUtil.mix((acc6 += b72 + XXH3_64.contrib(b62, this.secShiftFinalA6)) ^ this.secShiftFinalB6, (acc7 += b62 + XXH3_64.contrib(b72, this.secShiftFinalA7)) ^ this.secShiftFinalB7));
    }

    @Override
    public <T> long hashBytesToLong(T input, long off, long length, ByteAccess<T> access) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        long offStripe;
        int s;
        long offBlock;
        if (length <= 16L) {
            if (length > 8L) {
                long lo = access.getLong(input, off) ^ this.bitflip34;
                long hi = access.getLong(input, off + length - 8L) ^ this.bitflip56;
                long acc = length + Long.reverseBytes(lo) + hi + HashUtil.mix(lo, hi);
                return XXH3_64.avalanche3(acc);
            }
            if (length >= 4L) {
                long input1 = access.getInt(input, off);
                long input2 = access.getIntAsUnsignedLong(input, off + length - 4L);
                long keyed = input2 ^ input1 << 32 ^ this.bitflip12;
                return XXH3_64.rrmxmx(keyed, length);
            }
            if (length != 0L) {
                int c1 = access.getByteAsUnsignedInt(input, off);
                byte c2 = access.getByte(input, off + (length >> 1));
                int c3 = access.getByteAsUnsignedInt(input, off + length - 1L);
                long combined = ((long)(c1 << 16 | c2 << 24 | c3) | length << 8) & 0xFFFFFFFFL;
                return XXH3_64.avalanche64(combined ^ this.bitflip00);
            }
            return this.hash0;
        }
        if (length <= 128L) {
            long acc = length * -7046029288634856825L;
            if (length > 32L) {
                if (length > 64L) {
                    if (length > 96L) {
                        acc += XXH3_64.mix16B(input, off + 48L, this.secret, 12, access);
                        acc += XXH3_64.mix16B(input, off + length - 64L, this.secret, 14, access);
                    }
                    acc += XXH3_64.mix16B(input, off + 32L, this.secret, 8, access);
                    acc += XXH3_64.mix16B(input, off + length - 48L, this.secret, 10, access);
                }
                acc += XXH3_64.mix16B(input, off + 16L, this.secret, 4, access);
                acc += XXH3_64.mix16B(input, off + length - 32L, this.secret, 6, access);
            }
            acc += XXH3_64.mix16B(input, off, this.secret, 0, access);
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16L, this.secret, 2, access));
        }
        if (length <= 240L) {
            int i;
            long acc = length * -7046029288634856825L;
            int nbRounds = (int)length >>> 4;
            for (i = 0; i < 8; ++i) {
                acc += XXH3_64.mix16B(input, off + (long)(i << 4), this.secret, i << 1, access);
            }
            acc = XXH3_64.avalanche3(acc);
            while (i < nbRounds) {
                acc += XXH3_64.mix16B(input, off + (long)(i << 4), this.secShift, (i << 1) - 16, access);
                ++i;
            }
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16L, this.secShift, 14, access));
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        long nbBlocks = length - 1L >>> 10;
        for (long n = 0L; n < nbBlocks; ++n) {
            offBlock = off + (n << 10);
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (long)(s << 6);
                b0 = access.getLong(input, offStripe + 0L);
                b1 = access.getLong(input, offStripe + 8L);
                b2 = access.getLong(input, offStripe + 16L);
                b3 = access.getLong(input, offStripe + 24L);
                b4 = access.getLong(input, offStripe + 32L);
                b5 = access.getLong(input, offStripe + 40L);
                b6 = access.getLong(input, offStripe + 48L);
                b7 = access.getLong(input, offStripe + 56L);
                acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
                acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_64.mixAcc(acc0, this.secret[16]);
            acc1 = XXH3_64.mixAcc(acc1, this.secret[17]);
            acc2 = XXH3_64.mixAcc(acc2, this.secret[18]);
            acc3 = XXH3_64.mixAcc(acc3, this.secret[19]);
            acc4 = XXH3_64.mixAcc(acc4, this.secret[20]);
            acc5 = XXH3_64.mixAcc(acc5, this.secret[21]);
            acc6 = XXH3_64.mixAcc(acc6, this.secret[22]);
            acc7 = XXH3_64.mixAcc(acc7, this.secret[23]);
        }
        long nbStripes = length - 1L - (nbBlocks << 10) >>> 6;
        offBlock = off + (nbBlocks << 10);
        s = 0;
        while ((long)s < nbStripes) {
            offStripe = offBlock + (long)(s << 6);
            b0 = access.getLong(input, offStripe + 0L);
            b1 = access.getLong(input, offStripe + 8L);
            b2 = access.getLong(input, offStripe + 16L);
            b3 = access.getLong(input, offStripe + 24L);
            b4 = access.getLong(input, offStripe + 32L);
            b5 = access.getLong(input, offStripe + 40L);
            b6 = access.getLong(input, offStripe + 48L);
            b7 = access.getLong(input, offStripe + 56L);
            acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
            acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
            ++s;
        }
        long result = length * -7046029288634856825L;
        long offStripe2 = off + length - 64L;
        long b02 = access.getLong(input, offStripe2 + 0L);
        long b12 = access.getLong(input, offStripe2 + 8L);
        long b22 = access.getLong(input, offStripe2 + 16L);
        long b32 = access.getLong(input, offStripe2 + 24L);
        long b42 = access.getLong(input, offStripe2 + 32L);
        long b52 = access.getLong(input, offStripe2 + 40L);
        long b62 = access.getLong(input, offStripe2 + 48L);
        long b72 = access.getLong(input, offStripe2 + 56L);
        result += HashUtil.mix((acc0 += b12 + XXH3_64.contrib(b02, this.secShiftFinalA0)) ^ this.secShiftFinalB0, (acc1 += b02 + XXH3_64.contrib(b12, this.secShiftFinalA1)) ^ this.secShiftFinalB1);
        result += HashUtil.mix((acc2 += b32 + XXH3_64.contrib(b22, this.secShiftFinalA2)) ^ this.secShiftFinalB2, (acc3 += b22 + XXH3_64.contrib(b32, this.secShiftFinalA3)) ^ this.secShiftFinalB3);
        result += HashUtil.mix((acc4 += b52 + XXH3_64.contrib(b42, this.secShiftFinalA4)) ^ this.secShiftFinalB4, (acc5 += b42 + XXH3_64.contrib(b52, this.secShiftFinalA5)) ^ this.secShiftFinalB5);
        return XXH3_64.avalanche3(result += HashUtil.mix((acc6 += b72 + XXH3_64.contrib(b62, this.secShiftFinalA6)) ^ this.secShiftFinalB6, (acc7 += b62 + XXH3_64.contrib(b72, this.secShiftFinalA7)) ^ this.secShiftFinalB7));
    }

    @Override
    public long hashCharsToLong(CharSequence charSequence) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int offStripe;
        int s;
        int offBlock;
        int len = charSequence.length();
        if (len <= 8) {
            if (len > 4) {
                long lo = ByteArrayUtil.getLong(charSequence, 0) ^ this.bitflip34;
                long hi = ByteArrayUtil.getLong(charSequence, len - 4) ^ this.bitflip56;
                long acc = (long)(len << 1) + Long.reverseBytes(lo) + hi + HashUtil.mix(lo, hi);
                return XXH3_64.avalanche3(acc);
            }
            if (len >= 2) {
                long input1 = ByteArrayUtil.getInt(charSequence, 0);
                long input2 = ByteArrayUtil.getInt(charSequence, len - 2);
                long keyed = input2 & 0xFFFFFFFFL ^ input1 << 32 ^ this.bitflip12;
                return XXH3_64.rrmxmx(keyed, len << 1);
            }
            if (len != 0) {
                long c = charSequence.charAt(0);
                return XXH3_64.avalanche64(c << 16 ^ c >>> 8 ^ 0x200L ^ this.bitflip00);
            }
            return this.hash0;
        }
        if (len <= 64) {
            long acc = (long)len * 4354685496439837966L;
            if (len > 16) {
                if (len > 32) {
                    if (len > 48) {
                        acc += XXH3_64.mix16B(charSequence, 24, this.secret, 12);
                        acc += XXH3_64.mix16B(charSequence, len - 32, this.secret, 14);
                    }
                    acc += XXH3_64.mix16B(charSequence, 16, this.secret, 8);
                    acc += XXH3_64.mix16B(charSequence, len - 24, this.secret, 10);
                }
                acc += XXH3_64.mix16B(charSequence, 8, this.secret, 4);
                acc += XXH3_64.mix16B(charSequence, len - 16, this.secret, 6);
            }
            acc += XXH3_64.mix16B(charSequence, 0, this.secret, 0);
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(charSequence, len - 8, this.secret, 2));
        }
        if (len <= 120) {
            int i;
            long acc = (long)len * 4354685496439837966L;
            int nbRounds = len >>> 3;
            for (i = 0; i < 8; ++i) {
                acc += XXH3_64.mix16B(charSequence, i << 3, this.secret, i << 1);
            }
            acc = XXH3_64.avalanche3(acc);
            while (i < nbRounds) {
                acc += XXH3_64.mix16B(charSequence, i << 3, this.secShift, i - 8 << 1);
                ++i;
            }
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(charSequence, len - 8, this.secShift, 14));
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        int nbBlocks = len - 1 >>> 9;
        for (int n = 0; n < nbBlocks; ++n) {
            offBlock = n << 9;
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (s << 5);
                b0 = ByteArrayUtil.getLong(charSequence, offStripe + 0);
                b1 = ByteArrayUtil.getLong(charSequence, offStripe + 4);
                b2 = ByteArrayUtil.getLong(charSequence, offStripe + 8);
                b3 = ByteArrayUtil.getLong(charSequence, offStripe + 12);
                b4 = ByteArrayUtil.getLong(charSequence, offStripe + 16);
                b5 = ByteArrayUtil.getLong(charSequence, offStripe + 20);
                b6 = ByteArrayUtil.getLong(charSequence, offStripe + 24);
                b7 = ByteArrayUtil.getLong(charSequence, offStripe + 28);
                acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
                acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_64.mixAcc(acc0, this.secret[16]);
            acc1 = XXH3_64.mixAcc(acc1, this.secret[17]);
            acc2 = XXH3_64.mixAcc(acc2, this.secret[18]);
            acc3 = XXH3_64.mixAcc(acc3, this.secret[19]);
            acc4 = XXH3_64.mixAcc(acc4, this.secret[20]);
            acc5 = XXH3_64.mixAcc(acc5, this.secret[21]);
            acc6 = XXH3_64.mixAcc(acc6, this.secret[22]);
            acc7 = XXH3_64.mixAcc(acc7, this.secret[23]);
        }
        int nbStripes = len - 1 - (nbBlocks << 9) >>> 5;
        offBlock = nbBlocks << 9;
        for (s = 0; s < nbStripes; ++s) {
            offStripe = offBlock + (s << 5);
            b0 = ByteArrayUtil.getLong(charSequence, offStripe + 0);
            b1 = ByteArrayUtil.getLong(charSequence, offStripe + 4);
            b2 = ByteArrayUtil.getLong(charSequence, offStripe + 8);
            b3 = ByteArrayUtil.getLong(charSequence, offStripe + 12);
            b4 = ByteArrayUtil.getLong(charSequence, offStripe + 16);
            b5 = ByteArrayUtil.getLong(charSequence, offStripe + 20);
            b6 = ByteArrayUtil.getLong(charSequence, offStripe + 24);
            b7 = ByteArrayUtil.getLong(charSequence, offStripe + 28);
            acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
            acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
        }
        long result = (long)len * 4354685496439837966L;
        int offStripe2 = len - 32;
        long b02 = ByteArrayUtil.getLong(charSequence, offStripe2 + 0);
        long b12 = ByteArrayUtil.getLong(charSequence, offStripe2 + 4);
        long b22 = ByteArrayUtil.getLong(charSequence, offStripe2 + 8);
        long b32 = ByteArrayUtil.getLong(charSequence, offStripe2 + 12);
        long b42 = ByteArrayUtil.getLong(charSequence, offStripe2 + 16);
        long b52 = ByteArrayUtil.getLong(charSequence, offStripe2 + 20);
        long b62 = ByteArrayUtil.getLong(charSequence, offStripe2 + 24);
        long b72 = ByteArrayUtil.getLong(charSequence, offStripe2 + 28);
        result += HashUtil.mix((acc0 += b12 + XXH3_64.contrib(b02, this.secShiftFinalA0)) ^ this.secShiftFinalB0, (acc1 += b02 + XXH3_64.contrib(b12, this.secShiftFinalA1)) ^ this.secShiftFinalB1);
        result += HashUtil.mix((acc2 += b32 + XXH3_64.contrib(b22, this.secShiftFinalA2)) ^ this.secShiftFinalB2, (acc3 += b22 + XXH3_64.contrib(b32, this.secShiftFinalA3)) ^ this.secShiftFinalB3);
        result += HashUtil.mix((acc4 += b52 + XXH3_64.contrib(b42, this.secShiftFinalA4)) ^ this.secShiftFinalB4, (acc5 += b42 + XXH3_64.contrib(b52, this.secShiftFinalA5)) ^ this.secShiftFinalB5);
        return XXH3_64.avalanche3(result += HashUtil.mix((acc6 += b72 + XXH3_64.contrib(b62, this.secShiftFinalA6)) ^ this.secShiftFinalB6, (acc7 += b62 + XXH3_64.contrib(b72, this.secShiftFinalA7)) ^ this.secShiftFinalB7));
    }

    @Override
    public long hashIntIntToLong(int v1, int v2) {
        return XXH3_64.rrmxmx((long)v1 << 32 ^ (long)v2 & 0xFFFFFFFFL ^ this.bitflip12, 8L);
    }

    @Override
    public long hashIntToLong(int v) {
        return XXH3_64.rrmxmx((long)v & 0xFFFFFFFFL ^ (long)v << 32 ^ this.bitflip12, 4L);
    }

    @Override
    public long hashLongToLong(long v) {
        return XXH3_64.rrmxmx(v << 32 ^ v >>> 32 ^ this.bitflip12, 8L);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long lo = v1 ^ this.bitflip34;
        long hi = v2 ^ this.bitflip56;
        long acc = 16L + Long.reverseBytes(lo) + hi + HashUtil.mix(lo, hi);
        return XXH3_64.avalanche3(acc);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long acc = -3084006263850599256L;
        acc += HashUtil.mix(v1 ^ this.secret[0], v2 ^ this.secret[1]);
        return XXH3_64.avalanche3(acc += HashUtil.mix(v2 ^ this.secret[2], v3 ^ this.secret[3]));
    }

    @Override
    protected long finish12Bytes(long a, long b) {
        long lo = a ^ this.bitflip34;
        long hi = b ^ this.bitflip56;
        long acc = 12L + Long.reverseBytes(lo) + hi + HashUtil.mix(lo, hi);
        return XXH3_64.avalanche3(acc);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof XXH3_64)) {
            return false;
        }
        XXH3_64 that = (XXH3_64)obj;
        return this.getSeed() == that.getSeed();
    }

    public int hashCode() {
        return Long.hashCode(this.getSeed());
    }

    private final class HashStreamImpl
    extends XXH3Base.HashStreamImplBase
    implements AbstractHashStream64 {
        private HashStreamImpl() {
        }

        @Override
        public long getAsLong() {
            long b7;
            long b6;
            long b5;
            long b4;
            long b3;
            long b2;
            long b1;
            long b0;
            if (this.byteCount >= 0L && this.byteCount <= 256L) {
                return XXH3_64.this.hashBytesToLong(this.buffer, 0, (int)this.byteCount);
            }
            ByteArrayUtil.setLong(this.buffer, 256, ByteArrayUtil.getLong(this.buffer, 0));
            long acc0Loc = this.acc0;
            long acc1Loc = this.acc1;
            long acc2Loc = this.acc2;
            long acc3Loc = this.acc3;
            long acc4Loc = this.acc4;
            long acc5Loc = this.acc5;
            long acc6Loc = this.acc6;
            long acc7Loc = this.acc7;
            int end = ((int)this.byteCount - 1 & 0xFF) - 64;
            int off = 0;
            int s = (int)this.byteCount - 1 >>> 6 & 0xC;
            while (off <= end) {
                b0 = ByteArrayUtil.getLong(this.buffer, off + 0);
                b1 = ByteArrayUtil.getLong(this.buffer, off + 8);
                b2 = ByteArrayUtil.getLong(this.buffer, off + 16);
                b3 = ByteArrayUtil.getLong(this.buffer, off + 24);
                b4 = ByteArrayUtil.getLong(this.buffer, off + 32);
                b5 = ByteArrayUtil.getLong(this.buffer, off + 40);
                b6 = ByteArrayUtil.getLong(this.buffer, off + 48);
                b7 = ByteArrayUtil.getLong(this.buffer, off + 56);
                acc0Loc += b1 + XXH3Base.contrib(b0, XXH3_64.this.secret[s + 0]);
                acc1Loc += b0 + XXH3Base.contrib(b1, XXH3_64.this.secret[s + 1]);
                acc2Loc += b3 + XXH3Base.contrib(b2, XXH3_64.this.secret[s + 2]);
                acc3Loc += b2 + XXH3Base.contrib(b3, XXH3_64.this.secret[s + 3]);
                acc4Loc += b5 + XXH3Base.contrib(b4, XXH3_64.this.secret[s + 4]);
                acc5Loc += b4 + XXH3Base.contrib(b5, XXH3_64.this.secret[s + 5]);
                acc6Loc += b7 + XXH3Base.contrib(b6, XXH3_64.this.secret[s + 6]);
                acc7Loc += b6 + XXH3Base.contrib(b7, XXH3_64.this.secret[s + 7]);
                off += 64;
                ++s;
            }
            long result = this.byteCount * -7046029288634856825L;
            b0 = ByteArrayUtil.getLong(this.buffer, this.offset - 64 & 0xFF);
            b1 = ByteArrayUtil.getLong(this.buffer, this.offset - 56 & 0xFF);
            b2 = ByteArrayUtil.getLong(this.buffer, this.offset - 48 & 0xFF);
            b3 = ByteArrayUtil.getLong(this.buffer, this.offset - 40 & 0xFF);
            b4 = ByteArrayUtil.getLong(this.buffer, this.offset - 32 & 0xFF);
            b5 = ByteArrayUtil.getLong(this.buffer, this.offset - 24 & 0xFF);
            b6 = ByteArrayUtil.getLong(this.buffer, this.offset - 16 & 0xFF);
            b7 = ByteArrayUtil.getLong(this.buffer, this.offset - 8 & 0xFF);
            result += HashUtil.mix((acc0Loc += b1 + XXH3Base.contrib(b0, XXH3_64.this.secShiftFinalA0)) ^ XXH3_64.this.secShiftFinalB0, (acc1Loc += b0 + XXH3Base.contrib(b1, XXH3_64.this.secShiftFinalA1)) ^ XXH3_64.this.secShiftFinalB1);
            result += HashUtil.mix((acc2Loc += b3 + XXH3Base.contrib(b2, XXH3_64.this.secShiftFinalA2)) ^ XXH3_64.this.secShiftFinalB2, (acc3Loc += b2 + XXH3Base.contrib(b3, XXH3_64.this.secShiftFinalA3)) ^ XXH3_64.this.secShiftFinalB3);
            result += HashUtil.mix((acc4Loc += b5 + XXH3Base.contrib(b4, XXH3_64.this.secShiftFinalA4)) ^ XXH3_64.this.secShiftFinalB4, (acc5Loc += b4 + XXH3Base.contrib(b5, XXH3_64.this.secShiftFinalA5)) ^ XXH3_64.this.secShiftFinalB5);
            return XXH3Base.avalanche3(result += HashUtil.mix((acc6Loc += b7 + XXH3Base.contrib(b6, XXH3_64.this.secShiftFinalA6)) ^ XXH3_64.this.secShiftFinalB6, (acc7Loc += b6 + XXH3Base.contrib(b7, XXH3_64.this.secShiftFinalA7)) ^ XXH3_64.this.secShiftFinalB7));
        }

        @Override
        public HashStream64 putByte(byte v) {
            this.putByteImpl(v);
            return this;
        }

        @Override
        public HashStream64 putShort(short v) {
            this.putShortImpl(v);
            return this;
        }

        @Override
        public HashStream64 putChar(char v) {
            this.putCharImpl(v);
            return this;
        }

        @Override
        public HashStream64 putInt(int v) {
            this.putIntImpl(v);
            return this;
        }

        @Override
        public HashStream64 putLong(long v) {
            this.putLongImpl(v);
            return this;
        }

        @Override
        public HashStream64 putBytes(byte[] b, int off, int len) {
            this.putBytesImpl(b, off, len);
            return this;
        }

        @Override
        public <T> HashStream64 putBytes(T b, long off, long len, ByteAccess<T> access) {
            this.putBytesImpl(b, off, len, access);
            return this;
        }

        @Override
        public HashStream64 putChars(CharSequence c) {
            this.putCharsImpl(c);
            return this;
        }

        @Override
        public HashStream64 reset() {
            this.resetImpl();
            return this;
        }

        @Override
        public Hasher64 getHasher() {
            return XXH3_64.this;
        }

        @Override
        public HashStream64 setState(byte[] state) {
            this.setStateImpl(state);
            return this;
        }
    }
}

