/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.dsl.builder.AlignKt;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveOperationDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveSourceDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModelCheck;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModelChecksKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveSourceModel;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveTargetModel;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.MoveUiUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 ,2\u00020\u0001:\u0004)*+,B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H'J\b\u0010$\u001a\u00020\u0017H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u0082\u0001\u0002-.\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "", "<init>", "()V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "source", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel;", "getSource", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel;", "target", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;", "getTarget", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;", "searchForText", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "getSearchForText", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "searchInComments", "getSearchInComments", "inSourceRoot", "", "getInSourceRoot", "()Z", "searchReferences", "getSearchReferences", "mppDeclarations", "getMppDeclarations", "moveCallBack", "Lcom/intellij/refactoring/move/MoveCallback;", "getMoveCallBack", "()Lcom/intellij/refactoring/move/MoveCallback;", "toDescriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveOperationDescriptor;", "isValidRefactoring", "buildPanel", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "Setting", "Files", "Declarations", "Companion", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files;", "intellij.kotlin.refactorings.move"})
public abstract sealed class K2MoveModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Setting searchForText = Setting.SEARCH_FOR_TEXT;
    @NotNull
    private final Setting searchInComments = Setting.SEARCH_IN_COMMENTS;
    @NotNull
    private final Setting searchReferences = Setting.SEARCH_REFERENCES;
    @NotNull
    private final Setting mppDeclarations = Setting.MPP_DECLARATIONS;

    private K2MoveModel() {
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract K2MoveSourceModel<?> getSource();

    @NotNull
    public abstract K2MoveTargetModel getTarget();

    @NotNull
    public final Setting getSearchForText() {
        return this.searchForText;
    }

    @NotNull
    public final Setting getSearchInComments() {
        return this.searchInComments;
    }

    public abstract boolean getInSourceRoot();

    @NotNull
    public final Setting getSearchReferences() {
        return this.searchReferences;
    }

    @NotNull
    public final Setting getMppDeclarations() {
        return this.mppDeclarations;
    }

    @Nullable
    public abstract MoveCallback getMoveCallBack();

    @RequiresReadLock
    @NotNull
    public abstract K2MoveOperationDescriptor<?> toDescriptor();

    public boolean isValidRefactoring() {
        return !((Collection)this.getSource().getElements()).isEmpty();
    }

    public void buildPanel(@NotNull Panel panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Panel $this$buildPanel_u24lambda_u240 = panel;
        boolean bl = false;
        Panel.row$default((Panel)$this$buildPanel_u24lambda_u240, null, arg_0 -> K2MoveModel.buildPanel$lambda$0$0(this, arg_0), (int)1, null);
    }

    private static final Unit buildPanel$lambda$0$0(K2MoveModel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> K2MoveModel.buildPanel$lambda$0$0$0(this$0, arg_0)).align(AlignKt.plus((AlignY)((AlignY)AlignY.TOP.INSTANCE), (AlignX)((AlignX)AlignX.LEFT.INSTANCE)));
        $this$row.panel(arg_0 -> K2MoveModel.buildPanel$lambda$0$0$1(this$0, arg_0)).align(AlignKt.plus((AlignY)((AlignY)AlignY.TOP.INSTANCE), (AlignX)((AlignX)AlignX.RIGHT.INSTANCE)));
        return Unit.INSTANCE;
    }

    private static final Unit buildPanel$lambda$0$0$0(K2MoveModel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Setting.createComboBox$default(this$0.searchForText, $this$panel, false, 2, null);
        this$0.searchReferences.createComboBox($this$panel, this$0.getInSourceRoot());
        return Unit.INSTANCE;
    }

    private static final Unit buildPanel$lambda$0$0$1(K2MoveModel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Setting.createComboBox$default(this$0.searchInComments, $this$panel, false, 2, null);
        this$0.mppDeclarations.createComboBox($this$panel, this$0.getInSourceRoot() && this$0 instanceof Declarations);
        return Unit.INSTANCE;
    }

    public /* synthetic */ K2MoveModel(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "elements", "", "Lcom/intellij/psi/PsiElement;", "targetContainer", "editor", "Lcom/intellij/openapi/editor/Editor;", "moveCallBack", "Lcom/intellij/refactoring/move/MoveCallback;", "([Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/refactoring/move/MoveCallback;)Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "intellij.kotlin.refactorings.move"})
    @SourceDebugExtension(value={"SMAP\nK2MoveModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,372:1\n3919#2:373\n4434#2,2:374\n1374#3:376\n1460#3,2:377\n808#3,11:379\n1462#3,3:390\n1740#3,3:393\n295#3,2:396\n23#4,2:398\n*S KotlinDebug\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Companion\n*L\n282#1:373\n282#1:374,2\n301#1:376\n301#1:377,2\n303#1:379,11\n301#1:390,3\n312#1:393,3\n326#1:396,2\n329#1:398,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final K2MoveModel create(@NotNull PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable Editor editor, @Nullable MoveCallback moveCallBack2) {
            K2MoveModel k2MoveModel;
            boolean bl;
            FqName explicitPkgMoveFqName;
            boolean inSourceRoot;
            List declarationsFromFiles;
            List elementsToMove;
            PsiElement project;
            block30: {
                void $this$flatMapTo$iv$iv;
                PsiElement psiElement;
                PsiElement elem;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
                PsiElement psiElement2 = (PsiElement)ArraysKt.firstOrNull((Object[])elements);
                if (psiElement2 == null || (psiElement2 = psiElement2.getProject()) == null) {
                    throw new IllegalStateException("Elements not part of project".toString());
                }
                project = psiElement2;
                PsiElement[] $this$filter$iv = elements;
                boolean $i$f$filter = false;
                PsiElement[] psiElementArray = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl2;
                    elem = element$iv$iv;
                    boolean bl3 = false;
                    psiElement = elem;
                    if (psiElement instanceof PsiDirectory || psiElement instanceof PsiFile) {
                        bl2 = true;
                    } else {
                        PsiElement container;
                        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(PsiFile.class), Reflection.getOrCreateKotlinClass(KtNamedDeclaration.class)};
                        if (PsiTreeUtilKt.parentOfTypes$default((PsiElement)elem, (KClass[])kClassArray, (boolean)false, (int)2, null) == null) {
                            throw new IllegalStateException("Element not in Kotlin file".toString());
                        }
                        bl2 = !ArraysKt.contains((Object[])elements, (Object)container);
                    }
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                elementsToMove = (List)destination$iv$iv;
                if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, (Collection)ArraysKt.toList((Object[])elements), (boolean)true)) {
                    return null;
                }
                for (K2MoveModelCheck moveCheck : K2MoveModelChecksKt.getK2MoveModelChecks()) {
                    if (moveCheck.isMoveAllowed(elementsToMove, targetContainer)) continue;
                    moveCheck.showErrorHint((Project)project, editor);
                    return null;
                }
                Iterable $this$flatMap$iv = elementsToMove;
                boolean $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List list2;
                    elem = (PsiElement)element$iv$iv;
                    boolean bl4 = false;
                    psiElement = elem;
                    if (psiElement instanceof KtFile) {
                        void $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv = ((KtFile)elem).getDeclarations();
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv2 instanceof KtNamedDeclaration)) continue;
                            destination$iv$iv3.add(element$iv$iv2);
                        }
                        list2 = (List)destination$iv$iv3;
                    } else {
                        list2 = psiElement instanceof KtNamedDeclaration ? CollectionsKt.listOf((Object)elem) : CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                declarationsFromFiles = (List)destination$iv$iv2;
                inSourceRoot = MoveUiUtilKt.isInSourceRoot((Project)project, elementsToMove, targetContainer);
                explicitPkgMoveFqName = MoveUiUtilKt.findExplicitPkgMoveFqName(elementsToMove);
                Iterable $this$all$iv = elementsToMove;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl5 = false;
                        if (it instanceof KtFile) continue;
                        bl = false;
                        break block30;
                    }
                    bl = true;
                }
            }
            if (bl && targetContainer instanceof PsiDirectory || MoveUiUtilKt.isMultiFileMove(elementsToMove) || declarationsFromFiles.isEmpty() || targetContainer instanceof PsiDirectory && PackageUtilsKt.getPackage((PsiDirectory)targetContainer) == null) {
                K2MoveTargetModel.SourceDirectory sourceDirectory;
                source = new K2MoveSourceModel.FileSource(CollectionsKt.toSet((Iterable)MoveUiUtilKt.toFileElements(elementsToMove)));
                if (targetContainer instanceof PsiDirectory) {
                    FqName pkg = PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot((PsiDirectory)targetContainer);
                    sourceDirectory = new K2MoveTargetModel.SourceDirectory(pkg, (PsiDirectory)targetContainer, explicitPkgMoveFqName);
                } else {
                    KtElement ktElement;
                    Object v8;
                    PsiDirectory directory;
                    block32: {
                        PsiElement psiElement;
                        Object v5;
                        block31: {
                            Iterable $this$firstOrNull$iv = elementsToMove;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                PsiElement it = (PsiElement)element$iv;
                                boolean bl6 = false;
                                if (!(it.getContainingFile() != null)) continue;
                                v5 = element$iv;
                                break block31;
                            }
                            v5 = null;
                        }
                        if ((psiElement = (PsiElement)v5) == null || (psiElement = psiElement.getContainingFile()) == null) {
                            throw new IllegalStateException("No default target found".toString());
                        }
                        PsiElement file = psiElement;
                        PsiDirectory psiDirectory = file.getContainingDirectory();
                        if (psiDirectory == null) {
                            throw new IllegalStateException("No default target found".toString());
                        }
                        directory = psiDirectory;
                        Iterable $this$firstIsInstanceOrNull$iv = elementsToMove;
                        boolean $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                            if (!(element$iv instanceof KtElement)) continue;
                            v8 = element$iv;
                            break block32;
                        }
                        v8 = null;
                    }
                    if ((ktElement = (KtElement)v8) == null || (ktElement = ktElement.getContainingKtFile()) == null || (ktElement = ktElement.getPackageFqName()) == null) {
                        ktElement = FqName.ROOT;
                    }
                    KtElement pkgName = ktElement;
                    sourceDirectory = new K2MoveTargetModel.SourceDirectory((FqName)pkgName, directory, null);
                }
                K2MoveTargetModel.SourceDirectory target = sourceDirectory;
                k2MoveModel = new Files((Project)project, (K2MoveSourceModel.FileSource)source, target, inSourceRoot, moveCallBack2);
            } else if (targetContainer instanceof KtFile || MoveUiUtilKt.isSingleClassContainer(targetContainer) || MoveUiUtilKt.isSingleFileMove(elementsToMove)) {
                K2MoveTargetModel.FileChooser fileChooser;
                PsiFile targetFile;
                source = new K2MoveSourceModel.ElementSource(CollectionsKt.toSet((Iterable)declarationsFromFiles));
                PsiElement psiElement = targetContainer;
                Object object = targetFile = psiElement != null ? psiElement.getContainingFile() : null;
                if (targetFile instanceof KtFile) {
                    fileChooser = K2MoveTargetModel.Companion.File((KtFile)targetFile);
                } else if (targetContainer instanceof PsiDirectory) {
                    FqName pkg = PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot((PsiDirectory)targetContainer);
                    fileChooser = new K2MoveTargetModel.File(MoveUiUtilKt.findSourceFileNameByMovedElements(elementsToMove), pkg, (PsiDirectory)targetContainer, explicitPkgMoveFqName);
                } else {
                    Object object2 = CollectionsKt.firstOrNull((List)elementsToMove);
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                    KtElement firstElem = (KtElement)object2;
                    KtFile ktFile2 = firstElem.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
                    KtFile containingFile = ktFile2;
                    PsiDirectory psiDirectory = containingFile.getContainingDirectory();
                    if (psiDirectory == null) {
                        throw new IllegalStateException("No directory found".toString());
                    }
                    PsiDirectory psiDirectory2 = psiDirectory;
                    fileChooser = new K2MoveTargetModel.Declarations(psiDirectory2, containingFile.getPackageFqName(), MoveUiUtilKt.findSourceFileNameByMovedElements(elementsToMove));
                }
                K2MoveTargetModel.FileChooser target = fileChooser;
                k2MoveModel = new Declarations((Project)project, (K2MoveSourceModel.ElementSource)source, target, inSourceRoot, moveCallBack2);
            } else {
                throw new IllegalStateException("Unsupported move operation".toString());
            }
            return k2MoveModel;
        }

        public static /* synthetic */ K2MoveModel create$default(Companion companion, PsiElement[] psiElementArray, PsiElement psiElement, Editor editor, MoveCallback moveCallback, int n, Object object) {
            if ((n & 4) != 0) {
                editor = null;
            }
            if ((n & 8) != 0) {
                moveCallback = null;
            }
            return companion.create(psiElementArray, psiElement, editor, moveCallback);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\t*\u00020\u001cH\u0002J\r\u0010\u001d\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001b\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "project", "Lcom/intellij/openapi/project/Project;", "source", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$ElementSource;", "target", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;", "inSourceRoot", "", "moveCallBack", "Lcom/intellij/refactoring/move/MoveCallback;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$ElementSource;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;ZLcom/intellij/refactoring/move/MoveCallback;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSource", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$ElementSource;", "getTarget", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;", "getInSourceRoot", "()Z", "getMoveCallBack", "()Lcom/intellij/refactoring/move/MoveCallback;", "isValidFileRefactoring", "fileName", "", "isValidRefactoring", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$Declarations;", "isValidDeclarationsRefactoring", "isValidDeclarationsRefactoring$intellij_kotlin_refactorings_move", "toDescriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveOperationDescriptor$Declarations;", "intellij.kotlin.refactorings.move"})
    @SourceDebugExtension(value={"SMAP\nK2MoveModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n1563#2:373\n1634#2,3:374\n1761#2,3:379\n1374#2:382\n1460#2,2:383\n808#2,11:385\n1462#2,3:396\n1491#2:399\n1516#2,3:400\n1519#2,3:410\n2275#3,2:377\n382#4,7:403\n136#5,9:413\n216#5:422\n217#5:424\n145#5:425\n1#6:423\n*S KotlinDebug\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations\n*L\n204#1:373\n204#1:374,3\n236#1:379,3\n237#1:382\n237#1:383,2\n238#1:385,11\n237#1:396,3\n239#1:399\n239#1:400,3\n239#1:410,3\n214#1:377,2\n239#1:403,7\n241#1:413,9\n241#1:422\n241#1:424\n241#1:425\n241#1:423\n*E\n"})
    public static non-sealed class Declarations
    extends K2MoveModel {
        @NotNull
        private final Project project;
        @NotNull
        private final K2MoveSourceModel.ElementSource source;
        @NotNull
        private final K2MoveTargetModel target;
        private final boolean inSourceRoot;
        @Nullable
        private final MoveCallback moveCallBack;

        public Declarations(@NotNull Project project, @NotNull K2MoveSourceModel.ElementSource source, @NotNull K2MoveTargetModel target, boolean inSourceRoot, @Nullable MoveCallback moveCallBack2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super(null);
            this.project = project;
            this.source = source;
            this.target = target;
            this.inSourceRoot = inSourceRoot;
            this.moveCallBack = moveCallBack2;
        }

        public /* synthetic */ Declarations(Project project, K2MoveSourceModel.ElementSource elementSource, K2MoveTargetModel k2MoveTargetModel, boolean bl, MoveCallback moveCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                moveCallback = null;
            }
            this(project, elementSource, k2MoveTargetModel, bl, moveCallback);
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }

        @NotNull
        public K2MoveSourceModel.ElementSource getSource() {
            return this.source;
        }

        @Override
        @NotNull
        public K2MoveTargetModel getTarget() {
            return this.target;
        }

        @Override
        public boolean getInSourceRoot() {
            return this.inSourceRoot;
        }

        @Override
        @Nullable
        public MoveCallback getMoveCallBack() {
            return this.moveCallBack;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isValidFileRefactoring(String fileName) {
            void $this$mapTo$iv$iv;
            if (!MoveUiUtilKt.isValidKotlinFile(fileName)) {
                return false;
            }
            Iterable $this$map$iv = this.getSource().getElements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getContainingFile());
            }
            List files = (List)destination$iv$iv;
            if (files.size() != 1) return true;
            Object object = CollectionsKt.single((List)files);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            if (!Declarations.isValidFileRefactoring$isTargetFile((KtFile)object, this, fileName)) return true;
            if (!MoveUiUtilKt.isMoveToExplicitPackage(this.getTarget())) return false;
            return true;
        }

        private final boolean isValidRefactoring(K2MoveTargetModel.Declarations $this$isValidRefactoring) {
            boolean bl;
            block4: {
                if ($this$isValidRefactoring.getDestinationTargetType$intellij_kotlin_refactorings_move() == K2MoveTargetModel.Declarations.MoveTargetType.FILE) {
                    bl = this.isValidFileRefactoring($this$isValidRefactoring.getFileName());
                } else {
                    KtClassOrObject ktClassOrObject = $this$isValidRefactoring.getDestinationClass$intellij_kotlin_refactorings_move();
                    if (ktClassOrObject == null) {
                        return false;
                    }
                    KtClassOrObject destinationClass = ktClassOrObject;
                    Sequence $this$none$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)destinationClass));
                    boolean $i$f$none = false;
                    for (Object element$iv : $this$none$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!CollectionsKt.contains((Iterable)this.getSource().getElements(), (Object)it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean isValidDeclarationsRefactoring$intellij_kotlin_refactorings_move() {
            K2MoveTargetModel target = this.getTarget();
            K2MoveTargetModel k2MoveTargetModel = target;
            return k2MoveTargetModel instanceof K2MoveTargetModel.Declarations ? this.isValidRefactoring((K2MoveTargetModel.Declarations)target) : (k2MoveTargetModel instanceof K2MoveTargetModel.File ? this.isValidFileRefactoring(((K2MoveTargetModel.File)target).getFileName()) : false);
        }

        @Override
        public boolean isValidRefactoring() {
            return super.isValidRefactoring() && this.isValidDeclarationsRefactoring$intellij_kotlin_refactorings_move();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public K2MoveOperationDescriptor.Declarations toDescriptor() {
            Set<KtNamedDeclaration> declarations2 = this.getSource().getElements();
            boolean searchForReferences = this.getInSourceRoot() ? this.getSearchReferences().getState() : false;
            boolean searchForText = this.getSearchForText().getState();
            boolean searchInComments = this.getSearchInComments().getState();
            if (this.getMppDeclarations().getState()) {
                boolean bl;
                block13: {
                    Iterable $this$any$iv = declarations2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                            boolean bl2 = false;
                            if (!(KtPsiUtilKt.isExpectDeclaration((KtDeclaration)((KtDeclaration)it)) || PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)it)))) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    void $this$groupByTo$iv$iv;
                    Object $this$groupBy$iv;
                    Object object;
                    KtNamedDeclaration elem;
                    void $this$flatMapTo$iv$iv;
                    Object element$iv;
                    Iterable $this$flatMap$iv = declarations2;
                    boolean $i$f$flatMap = false;
                    element$iv = $this$flatMap$iv;
                    Object destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        void $this$filterIsInstanceTo$iv$iv;
                        elem = (KtNamedDeclaration)element$iv$iv;
                        boolean bl3 = false;
                        Iterable $this$filterIsInstance$iv = ExpectActualUtils.INSTANCE.withExpectedActuals((KtDeclaration)elem);
                        boolean $i$f$filterIsInstance = false;
                        object = $this$filterIsInstance$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv2 instanceof KtNamedDeclaration)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv;
                    boolean $i$f$groupBy = false;
                    $this$flatMapTo$iv$iv = $this$groupBy$iv;
                    destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$groupByTo = false;
                    for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object2;
                        void $this$getOrPut$iv$iv$iv;
                        elem = (KtNamedDeclaration)element$iv$iv;
                        boolean bl4 = false;
                        VirtualFile virtualFile = ProjectFileIndex.getInstance((Project)this.getProject()).getSourceRootForFile(elem.getContainingFile().getVirtualFile());
                        PsiDirectory key$iv$iv = virtualFile != null ? PhysicalFileSystemUtilsKt.toPsiDirectory(virtualFile, this.getProject()) : null;
                        Object $i$f$filterIsInstance = destination$iv$iv;
                        PsiDirectory key$iv$iv$iv = key$iv$iv;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl5 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                            object2 = answer$iv$iv$iv;
                        } else {
                            object2 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object2;
                        list$iv$iv.add(element$iv$iv);
                    }
                    $this$groupBy$iv = destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$groupByTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        K2MoveDescriptor.Declarations declarations3;
                        Map.Entry element$iv$iv$iv;
                        Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl6 = false;
                        object = element$iv$iv;
                        boolean bl7 = false;
                        PsiDirectory baseDir = (PsiDirectory)object.getKey();
                        List elements = (List)object.getValue();
                        if (baseDir == null) {
                            declarations3 = null;
                        } else {
                            K2MoveSourceDescriptor.ElementSource srcDescriptor = new K2MoveSourceDescriptor.ElementSource(elements);
                            K2MoveTargetDescriptor k2MoveTargetDescriptor = this.getTarget().toDescriptor(baseDir);
                            Intrinsics.checkNotNull((Object)k2MoveTargetDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor.Declaration<*>");
                            K2MoveTargetDescriptor.Declaration targetDescriptor = (K2MoveTargetDescriptor.Declaration)k2MoveTargetDescriptor;
                            declarations3 = new K2MoveDescriptor.Declarations(this.getProject(), srcDescriptor, targetDescriptor);
                        }
                        if (declarations3 == null) continue;
                        K2MoveDescriptor.Declarations it$iv$iv = declarations3;
                        boolean bl8 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List descriptors = (List)destination$iv$iv;
                    return new K2MoveOperationDescriptor.Declarations(this.getProject(), descriptors, searchForText, searchInComments, searchForReferences, true, this.getMoveCallBack());
                }
            }
            K2MoveSourceDescriptor.ElementSource srcDescr = new K2MoveSourceDescriptor.ElementSource((Collection<? extends KtNamedDeclaration>)declarations2);
            K2MoveTargetDescriptor k2MoveTargetDescriptor = K2MoveTargetModel.toDescriptor$default(this.getTarget(), null, 1, null);
            Intrinsics.checkNotNull((Object)k2MoveTargetDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor.Declaration<*>");
            K2MoveTargetDescriptor.Declaration targetDescr = (K2MoveTargetDescriptor.Declaration)k2MoveTargetDescriptor;
            K2MoveDescriptor.Declarations moveDescriptor = new K2MoveDescriptor.Declarations(this.getProject(), srcDescr, targetDescr);
            return new K2MoveOperationDescriptor.Declarations(this.getProject(), CollectionsKt.listOf((Object)moveDescriptor), searchForText, searchInComments, searchForReferences, true, this.getMoveCallBack());
        }

        private static final boolean isValidFileRefactoring$isTargetFile(KtFile $this$isValidFileRefactoring_u24isTargetFile, Declarations this$0, String $fileName) {
            return Intrinsics.areEqual((Object)$this$isValidFileRefactoring_u24isTargetFile.getContainingDirectory(), (Object)this$0.getTarget().getDirectory()) && Intrinsics.areEqual((Object)$this$isValidFileRefactoring_u24isTargetFile.getPackageFqName(), (Object)this$0.getTarget().getPkgName()) && Intrinsics.areEqual((Object)$this$isValidFileRefactoring_u24isTargetFile.getName(), (Object)$fileName);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\f\u0010\u0018\u001a\u00020\t*\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "project", "Lcom/intellij/openapi/project/Project;", "source", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$FileSource;", "target", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$SourceDirectory;", "inSourceRoot", "", "moveCallBack", "Lcom/intellij/refactoring/move/MoveCallback;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$FileSource;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$SourceDirectory;ZLcom/intellij/refactoring/move/MoveCallback;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSource", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$FileSource;", "getTarget", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$SourceDirectory;", "getInSourceRoot", "()Z", "getMoveCallBack", "()Lcom/intellij/refactoring/move/MoveCallback;", "isAlreadyInTarget", "Lcom/intellij/psi/PsiFile;", "isValidRefactoring", "toDescriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveOperationDescriptor$Files;", "intellij.kotlin.refactorings.move"})
    @SourceDebugExtension(value={"SMAP\nK2MoveModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,372:1\n1740#2,3:373\n*S KotlinDebug\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files\n*L\n160#1:373,3\n*E\n"})
    public static final class Files
    extends K2MoveModel {
        @NotNull
        private final Project project;
        @NotNull
        private final K2MoveSourceModel.FileSource source;
        @NotNull
        private final K2MoveTargetModel.SourceDirectory target;
        private final boolean inSourceRoot;
        @Nullable
        private final MoveCallback moveCallBack;

        public Files(@NotNull Project project, @NotNull K2MoveSourceModel.FileSource source, @NotNull K2MoveTargetModel.SourceDirectory target, boolean inSourceRoot, @Nullable MoveCallback moveCallBack2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super(null);
            this.project = project;
            this.source = source;
            this.target = target;
            this.inSourceRoot = inSourceRoot;
            this.moveCallBack = moveCallBack2;
        }

        public /* synthetic */ Files(Project project, K2MoveSourceModel.FileSource fileSource, K2MoveTargetModel.SourceDirectory sourceDirectory, boolean bl, MoveCallback moveCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                moveCallback = null;
            }
            this(project, fileSource, sourceDirectory, bl, moveCallback);
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }

        @NotNull
        public K2MoveSourceModel.FileSource getSource() {
            return this.source;
        }

        @Override
        @NotNull
        public K2MoveTargetModel.SourceDirectory getTarget() {
            return this.target;
        }

        @Override
        public boolean getInSourceRoot() {
            return this.inSourceRoot;
        }

        @Override
        @Nullable
        public MoveCallback getMoveCallBack() {
            return this.moveCallBack;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAlreadyInTarget(PsiFile $this$isAlreadyInTarget) {
            if (!Intrinsics.areEqual((Object)$this$isAlreadyInTarget.getParent(), (Object)this.getTarget().getDirectory())) return false;
            PsiFile psiFile = $this$isAlreadyInTarget;
            if (!(psiFile instanceof PsiJavaFile)) {
                if (!(psiFile instanceof KtFile)) return true;
                if (!Intrinsics.areEqual((Object)((KtFile)$this$isAlreadyInTarget).getPackageFqName(), (Object)this.getTarget().getPkgName())) return false;
                if (MoveUiUtilKt.isMoveToExplicitPackage(this.getTarget())) return false;
                return true;
            }
            boolean bl = Intrinsics.areEqual((Object)((PsiJavaFile)$this$isAlreadyInTarget).getPackageName(), (Object)this.getTarget().getPkgName().asString());
            if (!bl) return false;
            return true;
        }

        @Override
        public boolean isValidRefactoring() {
            boolean bl;
            block4: {
                if (!super.isValidRefactoring()) {
                    return false;
                }
                Iterable $this$all$iv = this.getSource().getElements();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiFileSystemItem it = (PsiFileSystemItem)element$iv;
                        boolean bl2 = false;
                        if (it instanceof PsiFile && this.isAlreadyInTarget((PsiFile)it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return !bl;
        }

        @NotNull
        public K2MoveOperationDescriptor.Files toDescriptor() {
            K2MoveSourceDescriptor.FileSource srcDescr = this.getSource().toDescriptor();
            K2MoveTargetDescriptor.Directory targetDescr = (K2MoveTargetDescriptor.Directory)K2MoveTargetModel.toDescriptor$default(this.getTarget(), null, 1, null);
            boolean searchReferences = this.getInSourceRoot() ? this.getSearchReferences().getState() : false;
            K2MoveDescriptor.Files moveDescriptor = new K2MoveDescriptor.Files(this.getProject(), srcDescr, targetDescr);
            Project project = this.getProject();
            List list2 = CollectionsKt.listOf((Object)moveDescriptor);
            boolean bl = this.getSearchForText().getState();
            boolean bl2 = this.getSearchInComments().getState();
            boolean bl3 = MoveUiUtilKt.isMoveToExplicitPackage(this.getTarget());
            MoveCallback moveCallback = this.getMoveCallBack();
            K2MoveOperationDescriptor.Files operationDescriptor = new K2MoveOperationDescriptor.Files(project, list2, bl, bl2, searchReferences, true, bl3, moveCallback);
            return operationDescriptor;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0016\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\fR\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Checkbox;", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "SEARCH_FOR_TEXT", "SEARCH_IN_COMMENTS", "SEARCH_REFERENCES", "MPP_DECLARATIONS", "state", "", "getState", "()Z", "setState", "(Z)V", "createComboBox", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "enabled", "intellij.kotlin.refactorings.move"})
    public static final abstract class Setting
    extends Enum<Setting> {
        @NotNull
        private final String text;
        public static final /* enum */ Setting SEARCH_FOR_TEXT = new SEARCH_FOR_TEXT("SEARCH_FOR_TEXT", 0);
        public static final /* enum */ Setting SEARCH_IN_COMMENTS = new SEARCH_IN_COMMENTS("SEARCH_IN_COMMENTS", 1);
        public static final /* enum */ Setting SEARCH_REFERENCES = new SEARCH_REFERENCES("SEARCH_REFERENCES", 2);
        public static final /* enum */ Setting MPP_DECLARATIONS = new MPP_DECLARATIONS("MPP_DECLARATIONS", 3);
        private static final /* synthetic */ Setting[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Setting(String text) {
            this.text = text;
        }

        public abstract boolean getState();

        public abstract void setState(boolean var1);

        public final void createComboBox(@NotNull Panel panel, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Panel.row$default((Panel)panel, null, arg_0 -> Setting.createComboBox$lambda$0(this, enabled, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        public static /* synthetic */ void createComboBox$default(Setting setting2, Panel panel, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createComboBox");
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            setting2.createComboBox(panel, bl);
        }

        public static Setting[] values() {
            return (Setting[])$VALUES.clone();
        }

        public static Setting valueOf(String value) {
            return Enum.valueOf(Setting.class, value);
        }

        @NotNull
        public static EnumEntries<Setting> getEntries() {
            return $ENTRIES;
        }

        private static final Unit createComboBox$lambda$0(Setting this$0, boolean $enabled, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell checkBox = $this$row.checkBox(this$0.text).enabled($enabled);
            Cell cell = $enabled ? ButtonKt.bindSelected((Cell)checkBox, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return ((Setting)((Object)this.receiver)).getState();
                }

                public void set(Object value) {
                    ((Setting)((Object)this.receiver)).setState((Boolean)value);
                }
            })) : ButtonKt.selected((Cell)checkBox, (boolean)false);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Setting(String $enum$name, int $enum$ordinal, String text, DefaultConstructorMarker $constructor_marker) {
            this(text);
        }

        static {
            $VALUES = settingArray = new Setting[]{Setting.SEARCH_FOR_TEXT, Setting.SEARCH_IN_COMMENTS, Setting.SEARCH_REFERENCES, Setting.MPP_DECLARATIONS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"org/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel.Setting.MPP_DECLARATIONS", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "intellij.kotlin.refactorings.move"})
        static final class MPP_DECLARATIONS
        extends Setting {
            /*
             * WARNING - void declaration
             */
            MPP_DECLARATIONS() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_MPP_DECLARATIONS();
            }

            @Override
            public void setState(boolean value) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_MPP_DECLARATIONS(value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"org/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel.Setting.SEARCH_FOR_TEXT", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "intellij.kotlin.refactorings.move"})
        static final class SEARCH_FOR_TEXT
        extends Setting {
            /*
             * WARNING - void declaration
             */
            SEARCH_FOR_TEXT() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_SEARCH_FOR_TEXT();
            }

            @Override
            public void setState(boolean value) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_SEARCH_FOR_TEXT(value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"org/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel.Setting.SEARCH_IN_COMMENTS", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "intellij.kotlin.refactorings.move"})
        static final class SEARCH_IN_COMMENTS
        extends Setting {
            /*
             * WARNING - void declaration
             */
            SEARCH_IN_COMMENTS() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_SEARCH_IN_COMMENTS();
            }

            @Override
            public void setState(boolean value) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_SEARCH_IN_COMMENTS(value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"org/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel.Setting.SEARCH_REFERENCES", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "intellij.kotlin.refactorings.move"})
        static final class SEARCH_REFERENCES
        extends Setting {
            /*
             * WARNING - void declaration
             */
            SEARCH_REFERENCES() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_SEARCH_REFERENCES();
            }

            @Override
            public void setState(boolean value) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_SEARCH_REFERENCES(value);
            }
        }
    }
}

