/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0000\u001a\u000e\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0000\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0001H\u0000\u00a8\u0006\u0005"}, d2={"nearestParentThatHasSemantics", "Landroidx/compose/ui/semantics/SemanticsInfo;", "findMergingSemanticsParent", "mergedSemanticsConfiguration", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "ui"})
@SourceDebugExtension(value={"SMAP\nSemanticsInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsInfo.kt\nandroidx/compose/ui/semantics/SemanticsInfoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ObjectList.kt\nandroidx/collection/ObjectList\n*L\n1#1,104:1\n1#2:105\n80#3:106\n*S KotlinDebug\n*F\n+ 1 SemanticsInfo.kt\nandroidx/compose/ui/semantics/SemanticsInfoKt\n*L\n88#1:106\n*E\n"})
public final class SemanticsInfoKt {
    @Nullable
    public static final SemanticsInfo nearestParentThatHasSemantics(@NotNull SemanticsInfo $this$nearestParentThatHasSemantics) {
        Intrinsics.checkNotNullParameter((Object)$this$nearestParentThatHasSemantics, (String)"<this>");
        for (SemanticsInfo parent = $this$nearestParentThatHasSemantics.getParentInfo(); parent != null; parent = parent.getParentInfo()) {
            if (parent.getSemanticsConfiguration() == null) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static final SemanticsInfo findMergingSemanticsParent(@NotNull SemanticsInfo $this$findMergingSemanticsParent) {
        Intrinsics.checkNotNullParameter((Object)$this$findMergingSemanticsParent, (String)"<this>");
        for (SemanticsInfo parent = $this$findMergingSemanticsParent.getParentInfo(); parent != null; parent = parent.getParentInfo()) {
            SemanticsConfiguration semanticsConfiguration = parent.getSemanticsConfiguration();
            boolean bl = semanticsConfiguration != null ? semanticsConfiguration.isMergingSemanticsOfDescendants() : false;
            if (!bl) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static final SemanticsConfiguration mergedSemanticsConfiguration(@NotNull SemanticsInfo $this$mergedSemanticsConfiguration) {
        MutableObjectList mutableObjectList;
        Intrinsics.checkNotNullParameter((Object)$this$mergedSemanticsConfiguration, (String)"<this>");
        SemanticsConfiguration unMergedConfig = $this$mergedSemanticsConfiguration.getSemanticsConfiguration();
        if (unMergedConfig == null || !unMergedConfig.isMergingSemanticsOfDescendants() || unMergedConfig.isClearingSemantics()) {
            return unMergedConfig;
        }
        SemanticsConfiguration mergedConfig = unMergedConfig.copy();
        MutableObjectList $this$mergedSemanticsConfiguration_u24lambda_u240 = mutableObjectList = new MutableObjectList($this$mergedSemanticsConfiguration.getChildrenInfo().size());
        boolean bl = false;
        $this$mergedSemanticsConfiguration_u24lambda_u240.addAll($this$mergedSemanticsConfiguration.getChildrenInfo());
        MutableObjectList needsMerging = mutableObjectList;
        while (needsMerging.isNotEmpty()) {
            ObjectList this_$iv = (ObjectList)needsMerging;
            boolean $i$f$getLastIndex = false;
            SemanticsInfo childInfo = (SemanticsInfo)needsMerging.removeAt(this_$iv._size - 1);
            SemanticsConfiguration childConfig = childInfo.getSemanticsConfiguration();
            if (childConfig == null || childConfig.isMergingSemanticsOfDescendants()) continue;
            mergedConfig.mergeChild$ui(childConfig);
            if (childConfig.isClearingSemantics()) continue;
            needsMerging.addAll(childInfo.getChildrenInfo());
        }
        return mergedConfig;
    }
}

