/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.sql.analysis.symbol.Namespace;
import org.opensearch.sql.analysis.symbol.Symbol;
import org.opensearch.sql.analysis.symbol.SymbolTable;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.env.Environment;

public class TypeEnvironment
implements Environment<Symbol, ExprType> {
    private final TypeEnvironment parent;
    private final SymbolTable symbolTable;

    public TypeEnvironment(TypeEnvironment parent) {
        this.parent = parent;
        this.symbolTable = new SymbolTable();
    }

    public TypeEnvironment(TypeEnvironment parent, SymbolTable symbolTable) {
        this.parent = parent;
        this.symbolTable = symbolTable;
    }

    @Override
    public ExprType resolve(Symbol symbol) {
        TypeEnvironment cur = this;
        while (cur != null) {
            Optional<ExprType> typeOptional = cur.symbolTable.lookup(symbol);
            if (typeOptional.isPresent()) {
                return typeOptional.get();
            }
            cur = cur.parent;
        }
        throw new SemanticCheckException(String.format("can't resolve %s in type env", symbol));
    }

    public Map<String, ExprType> lookupAllFields(Namespace namespace) {
        LinkedHashMap<String, ExprType> result = new LinkedHashMap<String, ExprType>();
        this.symbolTable.lookupAllFields(namespace).forEach(result::putIfAbsent);
        return result;
    }

    public Map<String, ExprType> lookupAllTupleFields(Namespace namespace) {
        LinkedHashMap<String, ExprType> result = new LinkedHashMap<String, ExprType>();
        this.symbolTable.lookupAllTupleFields(namespace).forEach(result::putIfAbsent);
        return result;
    }

    public void define(Symbol symbol, ExprType type) {
        this.symbolTable.store(symbol, type);
    }

    public void define(ReferenceExpression ref) {
        this.define(new Symbol(Namespace.FIELD_NAME, ref.getAttr()), ref.type());
    }

    public void remove(Symbol symbol) {
        this.symbolTable.remove(symbol);
    }

    public void remove(ReferenceExpression ref) {
        this.remove(new Symbol(Namespace.FIELD_NAME, ref.getAttr()));
    }

    public void clearAllFields() {
        this.lookupAllFields(Namespace.FIELD_NAME).keySet().forEach(v -> this.remove(new Symbol(Namespace.FIELD_NAME, (String)v)));
    }

    @Generated
    public TypeEnvironment getParent() {
        return this.parent;
    }
}

