/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.KeySize;
import org.opensaml.xmlsec.encryption.OAEPparams;

public class EncryptionMethodImpl
extends AbstractXMLObject
implements EncryptionMethod {
    @Nullable
    private String algorithm;
    @Nullable
    private KeySize keySize;
    @Nullable
    private OAEPparams oaepParams;
    @Nonnull
    private final IndexedXMLObjectChildrenList<XMLObject> unknownChildren = new IndexedXMLObjectChildrenList(this);

    protected EncryptionMethodImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setAlgorithm(@Nullable String newAlgorithm) {
        this.algorithm = this.prepareForAssignment(this.algorithm, newAlgorithm);
    }

    @Override
    @Nullable
    public KeySize getKeySize() {
        return this.keySize;
    }

    @Override
    public void setKeySize(@Nullable KeySize newKeySize) {
        this.keySize = this.prepareForAssignment(this.keySize, newKeySize);
    }

    @Override
    @Nullable
    public OAEPparams getOAEPparams() {
        return this.oaepParams;
    }

    @Override
    public void setOAEPparams(@Nullable OAEPparams newOAEPparams) {
        this.oaepParams = this.prepareForAssignment(this.oaepParams, newOAEPparams);
    }

    @Override
    @Nonnull
    @Live
    public List<XMLObject> getUnknownXMLObjects() {
        return this.unknownChildren;
    }

    @Override
    @Nonnull
    @Live
    public List<XMLObject> getUnknownXMLObjects(@Nonnull QName typeOrName) {
        return this.unknownChildren.subList(typeOrName);
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        if (this.keySize != null) {
            children.add(this.keySize);
        }
        if (this.oaepParams != null) {
            children.add(this.oaepParams);
        }
        children.addAll(this.unknownChildren);
        return CollectionSupport.copyToList(children);
    }
}

