# This file has been autogenerated by the pywayland scanner

# Copyright © 2018 NXP
# Copyright © 2019 Status Research & Development GmbH.
# Copyright © 2021 Xaver Hugl
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WpDrmLeaseV1(Interface):
    """A drm lease

    A DRM lease object is used to transfer the DRM file descriptor to the
    client and manage the lifetime of the lease.

    Some time after the :class:`WpDrmLeaseV1` object is created, the compositor
    will reply with the lease request's result. If the lease request is
    granted, the compositor will send a lease_fd event. If the lease request is
    denied, the compositor will send a finished event without a lease_fd event.
    """

    name = "wp_drm_lease_v1"
    version = 1


class WpDrmLeaseV1Proxy(Proxy[WpDrmLeaseV1]):
    interface = WpDrmLeaseV1

    @WpDrmLeaseV1.request()
    def destroy(self) -> None:
        """Destroys the lease object

        The client should send this to indicate that it no longer wishes to use
        this lease. The compositor should use drmModeRevokeLease on the
        appropriate file descriptor, if necessary.

        Upon destruction, the compositor should advertise the connector for
        leasing again by sending the connector event through the
        :class:`~pywayland.protocol.drm_lease_v1.WpDrmLeaseDeviceV1` interface.
        """
        self._marshal(0)
        self._destroy()


class WpDrmLeaseV1Resource(Resource):
    interface = WpDrmLeaseV1

    @WpDrmLeaseV1.event(
        Argument(ArgumentType.FileDescriptor),
    )
    def lease_fd(self, leased_fd: int) -> None:
        """Shares the drm file descriptor

        This event returns a file descriptor suitable for use with DRM-related
        ioctls. The client should use drmModeGetLease to enumerate the DRM
        objects which have been leased to them. The compositor guarantees it
        will not use the leased DRM objects itself until it sends the finished
        event. If the compositor cannot or will not grant a lease for the
        requested connectors, it will not send this event, instead sending the
        finished event.

        The compositor will send this event at most once during this objects
        lifetime.

        :param leased_fd:
            leased DRM file descriptor
        :type leased_fd:
            `ArgumentType.FileDescriptor`
        """
        self._post_event(0, leased_fd)

    @WpDrmLeaseV1.event()
    def finished(self) -> None:
        """Sent when the lease has been revoked

        The compositor uses this event to either reject a lease request, or if
        it previously sent a lease_fd, to notify the client that the lease has
        been revoked. If the client requires a new lease, they should destroy
        this object and submit a new lease request. The compositor will send no
        further events for this object after sending the finish event.
        Compositors should revoke the lease when any of the leased resources
        become unavailable, namely when a hot-unplug occurs or when the
        compositor loses DRM master. Compositors may advertise the connector
        for leasing again, if the resource is available, by sending the
        connector event through the
        :class:`~pywayland.protocol.drm_lease_v1.WpDrmLeaseDeviceV1` interface.
        """
        self._post_event(1)


class WpDrmLeaseV1Global(Global):
    interface = WpDrmLeaseV1


WpDrmLeaseV1._gen_c()
WpDrmLeaseV1.proxy_class = WpDrmLeaseV1Proxy
WpDrmLeaseV1.resource_class = WpDrmLeaseV1Resource
WpDrmLeaseV1.global_class = WpDrmLeaseV1Global
