/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.extern.decimal;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class DecimalType
extends Enum<DecimalType> {
    public static final /* enum */ DecimalType FINITE = new DecimalType(){

        @Override
        int getSpecialBits() {
            throw new IllegalStateException("Type FINITE has no special bits");
        }
    };
    public static final /* enum */ DecimalType INFINITY = new DecimalType(){

        @Override
        int getSpecialBits() {
            return 120;
        }
    };
    public static final /* enum */ DecimalType NAN = new DecimalType(){

        @Override
        int getSpecialBits() {
            return 124;
        }
    };
    public static final /* enum */ DecimalType SIGNALING_NAN = new DecimalType(){

        @Override
        int getSpecialBits() {
            return 126;
        }
    };
    private static final int TYPE_MASK = 126;
    private static final int INFINITY_0 = 120;
    private static final int INFINITY_2 = 122;
    private static final int NAN_QUIET = 124;
    private static final int NAN_SIGNAL = 126;
    private static final /* synthetic */ DecimalType[] $VALUES;

    public static DecimalType[] values() {
        return (DecimalType[])$VALUES.clone();
    }

    public static DecimalType valueOf(String name) {
        return Enum.valueOf(DecimalType.class, name);
    }

    abstract int getSpecialBits();

    static DecimalType fromFirstByte(byte firstByte) {
        return DecimalType.fromFirstByte((int)firstByte);
    }

    static DecimalType fromFirstByte(int firstByte) {
        int type = firstByte & 0x7E;
        switch (type) {
            case 120: 
            case 122: {
                return INFINITY;
            }
            case 124: {
                return NAN;
            }
            case 126: {
                return SIGNALING_NAN;
            }
        }
        assert ((firstByte & 0x78) != 120) : "Invalid special " + firstByte;
        return FINITE;
    }

    private static /* synthetic */ DecimalType[] $values() {
        return new DecimalType[]{FINITE, INFINITY, NAN, SIGNALING_NAN};
    }

    static {
        $VALUES = DecimalType.$values();
    }
}

