/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firebirdsql.gds.impl.GDSServerVersionException;

public final class GDSServerVersion
implements Serializable {
    private static final long serialVersionUID = -3401092369588765195L;
    public static final String TYPE_PRODUCTION = "V";
    public static final String TYPE_BETA = "T";
    public static final String TYPE_DEVELOPMENT = "X";
    public static final String CONNECTION_OPTION_ENCRYPTED = "C";
    public static final String CONNECTION_OPTION_COMPRESSION = "Z";
    public static final GDSServerVersion INVALID_VERSION = new GDSServerVersion(new String[]{"INVALID"}, "", "", "", 0, 0, 0, 0, "");
    private static final Pattern VERSION_PATTERN = Pattern.compile("((\\w{2})-(\\w)(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)(?:-\\S+)?) (.+)");
    private static final Pattern CONNECTION_METADATA_PATTERN = Pattern.compile("/P(\\d+)(?::([^:]+))?$");
    private static final int FULL_VERSION_IDX = 1;
    private static final int PLATFORM_IDX = 2;
    private static final int TYPE_IDX = 3;
    private static final int MAJOR_IDX = 4;
    private static final int MINOR_IDX = 5;
    private static final int VARIANT_IDX = 6;
    private static final int BUILD_IDX = 7;
    private static final int SERVER_NAME_IDX = 8;
    private final String[] rawVersions;
    private final String platform;
    private final String type;
    private final String fullVersion;
    private final int majorVersion;
    private final int minorVersion;
    private final int variant;
    private final int buildNumber;
    private final String serverName;

    private GDSServerVersion(String[] rawVersions, String platform, String type, String fullVersion, int majorVersion, int minorVersion, int variant, int buildNumber, String serverName) {
        this.rawVersions = (String[])rawVersions.clone();
        this.platform = platform;
        this.type = type;
        this.fullVersion = fullVersion;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.variant = variant;
        this.buildNumber = buildNumber;
        this.serverName = serverName;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getType() {
        return this.type;
    }

    public int getVariant() {
        return this.variant;
    }

    public List<String> getRawVersions() {
        return List.of(this.rawVersions);
    }

    public String getExtendedServerName() {
        if (this.rawVersions.length < 2) {
            return null;
        }
        if (this.rawVersions.length == 2) {
            return this.rawVersions[1];
        }
        StringBuilder sb = new StringBuilder((this.rawVersions[1].length() + 50) * (this.rawVersions.length - 1));
        for (int idx = 1; idx < this.rawVersions.length; ++idx) {
            if (idx > 1) {
                sb.append(',');
            }
            sb.append(this.rawVersions[idx]);
        }
        return sb.toString();
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public int getProtocolVersion() {
        if (this.rawVersions.length == 1 || this.rawVersions[1] == null) {
            return -1;
        }
        Matcher connectionMetadataMatcher = CONNECTION_METADATA_PATTERN.matcher(this.rawVersions[1]);
        if (!connectionMetadataMatcher.find()) {
            return -1;
        }
        String protocolVersion = connectionMetadataMatcher.group(1);
        return Integer.parseInt(protocolVersion);
    }

    public boolean isWireEncryptionUsed() {
        return this.getConnectionOptions().contains(CONNECTION_OPTION_ENCRYPTED);
    }

    public boolean isWireCompressionUsed() {
        return this.getConnectionOptions().contains(CONNECTION_OPTION_COMPRESSION);
    }

    private String getConnectionOptions() {
        if (this.rawVersions.length == 1 || this.rawVersions[1] == null) {
            return "";
        }
        Matcher connectionMetadataMatcher = CONNECTION_METADATA_PATTERN.matcher(this.rawVersions[1]);
        if (!connectionMetadataMatcher.find()) {
            return "";
        }
        String connectionOptions = connectionMetadataMatcher.group(2);
        return connectionOptions != null ? connectionOptions : "";
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawVersions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof GDSServerVersion)) return false;
        GDSServerVersion that = (GDSServerVersion)obj;
        if (!Arrays.equals(this.rawVersions, that.rawVersions)) return false;
        return true;
    }

    public String toString() {
        if (this.rawVersions.length == 1) {
            return this.rawVersions[0];
        }
        StringBuilder sb = new StringBuilder((this.rawVersions[0].length() + 50) * this.rawVersions.length);
        int idx = 0;
        sb.append(this.rawVersions[idx++]);
        do {
            sb.append(',');
            sb.append(this.rawVersions[idx++]);
        } while (idx < this.rawVersions.length);
        return sb.toString();
    }

    public static GDSServerVersion parseRawVersion(String ... versionStrings) throws GDSServerVersionException {
        if (versionStrings == null || versionStrings.length == 0 || versionStrings[0] == null) {
            throw new GDSServerVersionException("No version string information present");
        }
        Matcher matcher = VERSION_PATTERN.matcher(versionStrings[0]);
        if (!matcher.matches()) {
            throw new GDSServerVersionException(String.format("Version string \"%s\" does not match expected format", versionStrings[0]));
        }
        return new GDSServerVersion(versionStrings, matcher.group(2), matcher.group(3), matcher.group(1), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), matcher.group(8));
    }

    public boolean isEqualOrAbove(int requiredMajorVersion) {
        return this.majorVersion >= requiredMajorVersion;
    }

    public boolean isEqualOrAbove(int requiredMajorVersion, int requiredMinorVersion) {
        return this.majorVersion > requiredMajorVersion || this.majorVersion == requiredMajorVersion && this.minorVersion >= requiredMinorVersion;
    }

    public boolean isEqualOrAbove(int requiredMajorVersion, int requiredMinorVersion, int requiredVariant) {
        return this.majorVersion > requiredMajorVersion || this.majorVersion == requiredMajorVersion && (this.minorVersion == requiredMinorVersion && this.variant >= requiredVariant || this.minorVersion > requiredMinorVersion);
    }
}

