/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt.arc4;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionInitInfo;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.gds.ng.wire.crypt.arc4.Arc4EncryptionPluginSpi;

public final class Arc4EncryptionPlugin
implements EncryptionPlugin {
    private static final String ARCFOUR_CIPHER_NAME = "ARCFOUR";
    private final CryptSessionConfig cryptSessionConfig;

    Arc4EncryptionPlugin(CryptSessionConfig cryptSessionConfig) {
        this.cryptSessionConfig = cryptSessionConfig;
    }

    @Override
    public EncryptionIdentifier encryptionIdentifier() {
        return Arc4EncryptionPluginSpi.ARC4_ID;
    }

    @Override
    public EncryptionInitInfo initializeEncryption() {
        try {
            return EncryptionInitInfo.success(this.encryptionIdentifier(), this.createEncryptionCipher(), this.createDecryptionCipher());
        }
        catch (SQLException e) {
            return EncryptionInitInfo.failure(this.encryptionIdentifier(), e);
        }
    }

    private Cipher createEncryptionCipher() throws SQLException {
        return this.createCipher(1, this.cryptSessionConfig.encryptKey());
    }

    private Cipher createDecryptionCipher() throws SQLException {
        return this.createCipher(2, this.cryptSessionConfig.decryptKey());
    }

    private Cipher createCipher(int mode, byte[] key) throws SQLException {
        try {
            Cipher rc4Cipher = Cipher.getInstance(ARCFOUR_CIPHER_NAME);
            rc4Cipher.init(mode, new SecretKeySpec(key, ARCFOUR_CIPHER_NAME));
            return rc4Cipher;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw FbExceptionBuilder.forNonTransientException(337248281).messageParameter((Object)this.encryptionIdentifier()).cause(e).toSQLException();
        }
        catch (InvalidKeyException e) {
            throw FbExceptionBuilder.forNonTransientException(337248282).messageParameter((Object)this.encryptionIdentifier()).cause(e).toSQLException();
        }
    }
}

