/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiMemberAccessNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyDictSetDefault;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.CyclicAssumption;

public final class PythonCextTypeBuiltins {

    static abstract class GraalPyPrivate_Type_SetBufferProcs
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Type_SetBufferProcs() {
        }

        @Specialization
        static Object setBuiltinClassType(PythonBuiltinClassType clazz, Object bufferProcs, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HiddenAttr.WriteNode writeAttrNode) {
            writeAttrNode.execute(inliningTarget, PythonContext.get(inliningTarget).lookupType(clazz), HiddenAttr.AS_BUFFER, bufferProcs);
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"isPythonClass(object)"})
        static Object set(PythonAbstractObject object, Object bufferProcs, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HiddenAttr.WriteNode writeAttrNode) {
            writeAttrNode.execute(inliningTarget, object, HiddenAttr.AS_BUFFER, bufferProcs);
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_Type_AddGetSet
    extends PythonCextBuiltins.CApi7BuiltinNode {
        GraalPyPrivate_Type_AddGetSet() {
        }

        @Specialization
        static int doGeneric(Object cls, PDict dict, TruffleString name, Object getter, Object setter, Object doc, Object closure, @Bind Node inliningTarget, @Cached CreateGetSetNode createGetSetNode, @Cached PyDictSetDefault setDefault) {
            GetSetDescriptor descr = createGetSetNode.execute(inliningTarget, name, cls, getter, setter, doc, closure);
            setDefault.execute(null, inliningTarget, dict, name, descr);
            return 0;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CreateGetSetNode
    extends Node {
        CreateGetSetNode() {
        }

        abstract GetSetDescriptor execute(Node var1, TruffleString var2, Object var3, Object var4, Object var5, Object var6, Object var7);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static GetSetDescriptor createGetSet(Node inliningTarget, TruffleString name, Object cls, Object getter, Object setter, Object doc, Object closure, @CachedLibrary(limit="2") InteropLibrary interopLibrary) {
            boolean hasSetter;
            assert (!(doc instanceof CArrayWrappers.CArrayWrapper));
            PBuiltinFunction get = null;
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            if (!interopLibrary.isNull(getter)) {
                RootCallTarget getterCT = CreateGetSetNode.getterCallTarget(name, language);
                getter = CExtCommonNodes.EnsureExecutableNode.executeUncached(getter, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER);
                get = PFactory.createBuiltinFunction(language, name, cls, PythonUtils.EMPTY_OBJECT_ARRAY, ExternalFunctionNodes.createKwDefaults(getter, closure), 0, getterCT);
            }
            PBuiltinFunction set = null;
            boolean bl = hasSetter = !interopLibrary.isNull(setter);
            if (hasSetter) {
                RootCallTarget setterCT = CreateGetSetNode.setterCallTarget(name, language);
                setter = CExtCommonNodes.EnsureExecutableNode.executeUncached(setter, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER);
                set = PFactory.createBuiltinFunction(language, name, cls, PythonUtils.EMPTY_OBJECT_ARRAY, ExternalFunctionNodes.createKwDefaults(setter, closure), 0, setterCT);
            }
            GetSetDescriptor descriptor = PFactory.createGetSetDescriptor(language, get, set, name, cls, hasSetter);
            WriteAttributeToPythonObjectNode.executeUncached(descriptor, SpecialAttributeNames.T___DOC__, doc);
            return descriptor;
        }

        @CompilerDirectives.TruffleBoundary
        private static RootCallTarget getterCallTarget(TruffleString name, PythonLanguage lang) {
            Function rootNodeFunction = l -> new ExternalFunctionNodes.GetterRoot((PythonLanguage)((Object)l), name, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER);
            return lang.createCachedExternalFunWrapperCallTarget(rootNodeFunction, ExternalFunctionNodes.GetterRoot.class, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER, name, true, false);
        }

        @CompilerDirectives.TruffleBoundary
        private static RootCallTarget setterCallTarget(TruffleString name, PythonLanguage lang) {
            Function rootNodeFunction = l -> new ExternalFunctionNodes.SetterRoot((PythonLanguage)((Object)l), name, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER);
            return lang.createCachedExternalFunWrapperCallTarget(rootNodeFunction, ExternalFunctionNodes.SetterRoot.class, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER, name, true, false);
        }
    }

    public static abstract class GraalPyPrivate_Type_AddMember
    extends PythonCextBuiltins.CApi7BuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static int addMember(Object clazz, PDict tpDict, TruffleString memberName, int memberType, long offset, int canSet, Object memberDoc) {
            PythonLanguage language = PythonLanguage.get(null);
            PBuiltinFunction getterObject = CApiMemberAccessNodes.ReadMemberNode.createBuiltinFunction(language, clazz, memberName, memberType, (int)offset);
            PBuiltinFunction setterObject = null;
            if (canSet != 0) {
                setterObject = CApiMemberAccessNodes.WriteMemberNode.createBuiltinFunction(language, clazz, memberName, memberType, (int)offset);
            }
            GetSetDescriptor memberDescriptor = PFactory.createMemberDescriptor(language, getterObject, setterObject, memberName, clazz);
            WriteAttributeToPythonObjectNode.getUncached().execute(memberDescriptor, SpecialAttributeNames.T___DOC__, memberDoc);
            PyDictSetDefault.executeUncached(tpDict, memberName, memberDescriptor);
            return 0;
        }
    }

    static abstract class GraalPyPrivate_Type_AddOperators
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Type_AddOperators() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int addOperators(PythonAbstractNativeObject type) {
            TpSlots.addOperatorsToNative(type);
            return 0;
        }
    }

    static abstract class GraalPyPrivate_Type_AddFunctionToType
    extends PythonCextBuiltins.CApi8BuiltinNode {
        GraalPyPrivate_Type_AddFunctionToType() {
        }

        @Specialization
        static int classMethod(Object methodDefPtr, Object type, Object dict, TruffleString name, Object cfunc, int flags, int wrapper, Object doc, @Bind Node inliningTarget, @Cached NewClassMethodNode newClassMethodNode, @Cached PyDictSetDefault setDefault) {
            Object func = newClassMethodNode.execute(inliningTarget, methodDefPtr, name, cfunc, flags, wrapper, type, doc);
            setDefault.execute(null, inliningTarget, dict, name, func);
            return 0;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CExtContext.class})
    static abstract class NewClassMethodNode
    extends Node {
        NewClassMethodNode() {
        }

        abstract Object execute(Node var1, Object var2, TruffleString var3, Object var4, Object var5, Object var6, Object var7, Object var8);

        @Specialization(guards={"isClassOrStaticMethod(flags)"})
        static Object classOrStatic(Node inliningTarget, Object methodDefPtr, TruffleString name, Object methObj, int flags, int wrapper, Object type, Object doc, @Bind PythonLanguage language, @Cached.Exclusive @Cached HiddenAttr.WriteNode writeHiddenAttrNode, @Cached(inline=false) WriteAttributeToPythonObjectNode writeAttrNode) {
            PythonObject func = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, methObj, type, flags, wrapper, language);
            writeHiddenAttrNode.execute(inliningTarget, func, HiddenAttr.METHOD_DEF_PTR, methodDefPtr);
            PDecoratedMethod function = (flags & 0x10) != 0 ? PFactory.createClassmethodFromCallableObj(language, func) : PFactory.createStaticmethodFromCallableObj(language, func);
            writeAttrNode.execute(function, SpecialAttributeNames.T___NAME__, name);
            writeAttrNode.execute(function, SpecialAttributeNames.T___DOC__, doc);
            return function;
        }

        @Specialization(guards={"!isClassOrStaticMethod(flags)"})
        static Object doNativeCallable(Node inliningTarget, Object methodDefPtr, TruffleString name, Object methObj, int flags, int wrapper, Object type, Object doc, @Bind PythonLanguage language, @Cached PythonCextBuiltins.PyObjectSetAttrNode setattr, @Cached.Exclusive @Cached HiddenAttr.WriteNode writeNode) {
            PythonObject func = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, methObj, type, flags, wrapper, language);
            setattr.execute(inliningTarget, func, SpecialAttributeNames.T___NAME__, name);
            setattr.execute(inliningTarget, func, SpecialAttributeNames.T___DOC__, doc);
            writeNode.execute(inliningTarget, func, HiddenAttr.METHOD_DEF_PTR, methodDefPtr);
            return func;
        }
    }

    static abstract class GraalPyPrivate_Trace_Type
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(GraalPyPrivate_Trace_Type.class);

        GraalPyPrivate_Trace_Type() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int trace(Object ptr) {
            LOGGER.fine(() -> PythonUtils.formatJString("Initializing native type %s (ptr = %s)", CStructAccess.ReadCharPtrNode.getUncached().read(ptr, CFields.PyTypeObject__tp_name), CApiContext.asHex(CApiContext.asPointer(ptr, InteropLibrary.getUncached()))));
            return 0;
        }
    }

    static abstract class PyType_Modified
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyType_Modified() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object doIt(PythonAbstractClass object, @Bind Node inliningTarget) {
            if (object instanceof PythonAbstractNativeObject) {
                PythonAbstractNativeObject clazz = (PythonAbstractNativeObject)object;
                PythonContext context = PythonContext.get(inliningTarget);
                CyclicAssumption nativeClassStableAssumption = context.getNativeClassStableAssumption(clazz, false);
                if (nativeClassStableAssumption != null) {
                    nativeClassStableAssumption.invalidate("PyType_Modified(\"" + TypeNodes.GetNameNode.executeUncached(clazz).toJavaStringUncached() + "\") called");
                }
                MroSequenceStorage mroStorage = TypeNodes.GetMroStorageNode.executeUncached(clazz);
                mroStorage.lookupChanged();
                clazz.setTpSlots(TpSlots.fromNative(clazz, context));
            } else {
                MroSequenceStorage mroStorage = TypeNodes.GetMroStorageNode.executeUncached(object);
                mroStorage.lookupChanged();
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_NewTypeDict
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_NewTypeDict() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PDict doGeneric(PythonNativeClass nativeClass) {
            PythonLanguage language = PythonLanguage.get(null);
            NativeTypeDictStorage nativeTypeStore = new NativeTypeDictStorage(language.getEmptyShape());
            PDict dict = PFactory.createDict(language, new DynamicObjectStorage(nativeTypeStore));
            HiddenAttr.WriteNode.executeUncached(dict, HiddenAttr.INSTANCESHAPE, language.getShapeForClass(nativeClass));
            return dict;
        }
    }

    static final class NativeTypeDictStorage
    extends DynamicObject {
        public NativeTypeDictStorage(Shape shape) {
            super(shape);
        }
    }

    static abstract class GraalPyPrivate_Compute_Mro
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Compute_Mro() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doIt(PythonNativeClass self, TruffleString className, @Bind Node inliningTarget) {
            PythonAbstractClass[] doSlowPath = TypeNodes.ComputeMroNode.doSlowPath(inliningTarget, self);
            return PFactory.createTuple(PythonLanguage.get(null), new MroSequenceStorage(className, doSlowPath));
        }
    }

    static abstract class _PyType_Lookup
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyType_Lookup() {
        }

        @Specialization
        Object doGeneric(Object type, Object name, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TypeNodes.GetMroStorageNode getMroStorageNode, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteBorrowedValue, @Cached CStructAccess.ReadObjectNode getNativeDict, @Cached GetDictIfExistsNode getDictIfExistsNode, @CachedLibrary(limit="3") DynamicObjectLibrary dylib, @Cached PyDictGetItem getItem, @Cached PyDictSetItem setItem) {
            TruffleString key = castToTruffleStringNode.castKnownString(inliningTarget, name);
            MroSequenceStorage mro = getMroStorageNode.execute(inliningTarget, type);
            for (int i = 0; i < mro.length(); ++i) {
                PDict dict;
                PythonAbstractClass cls = mro.getPythonClassItemNormalized(i);
                if (cls instanceof PythonAbstractNativeObject) {
                    PDict d;
                    PythonAbstractNativeObject nativeCls = (PythonAbstractNativeObject)cls;
                    Object dictObj = getNativeDict.readFromObj(nativeCls, CFields.PyTypeObject__tp_dict);
                    if (!(dictObj instanceof PDict)) continue;
                    dict = d = (PDict)dictObj;
                } else if (cls instanceof PythonManagedClass) {
                    PythonManagedClass managedCls = (PythonManagedClass)cls;
                    dict = getDictIfExistsNode.execute(managedCls);
                } else {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                Object value = dict == null ? dylib.getOrDefault((DynamicObject)cls, (Object)key, null) : getItem.execute(null, inliningTarget, dict, key);
                if (value == null || value == PNone.NO_VALUE) continue;
                Object promoted = promoteBorrowedValue.execute(inliningTarget, value);
                if (promoted != null) {
                    if (dict == null) {
                        dylib.put((DynamicObject)cls, (Object)key, promoted);
                    } else {
                        setItem.execute(null, inliningTarget, dict, key, promoted);
                    }
                    return promoted;
                }
                return value;
            }
            return this.getNativeNull();
        }
    }
}

