/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNodeGen;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigInteger;

@TypeSystemReference(value=PythonIntegerTypes.class)
@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class CastToJavaUnsignedLongNode
extends PNodeWithContext {
    public static long executeUncached(Object arg) {
        return CastToJavaUnsignedLongNodeGen.getUncached().execute(null, arg);
    }

    public abstract long execute(Node var1, Object var2);

    @Specialization
    static long toUnsignedLong(Node inliningTarget, long x, @Cached.Shared @Cached PRaiseNode raiseNode) {
        CastToJavaUnsignedLongNode.checkNegative(x < 0L, inliningTarget, raiseNode);
        return x;
    }

    @Specialization
    static long toUnsignedLong(Node inliningTarget, PInt x, @Cached.Shared @Cached PRaiseNode raiseNode) {
        CastToJavaUnsignedLongNode.checkNegative(x.isNegative(), inliningTarget, raiseNode);
        return CastToJavaUnsignedLongNode.convertBigInt(x.getValue(), inliningTarget);
    }

    @Fallback
    static long doUnsupported(Node inliningTarget, Object x) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INTEGER_REQUIRED);
    }

    private static void checkNegative(boolean negative, Node inliningTarget, PRaiseNode raiseNode) {
        if (negative) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.CANNOT_CONVERT_NEGATIVE_VALUE_TO_UNSIGNED_INT);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static long convertBigInt(BigInteger bi, Node nodeForRaise) {
        if (bi.bitLength() > 64) {
            throw PRaiseNode.raiseStatic(nodeForRaise, PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "unsigned long");
        }
        return bi.longValue();
    }
}

