/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.CacheKey;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.MetadataVisitorException;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.util.Exceptions;

abstract class MetadataVisitor<R> {
    static final Object SKIP_SIBLINGS = InterruptedException.class;
    private final Map<Object, R> visited = new IdentityHashMap<Object, R>();
    private String[] propertyPath = new String[6];
    private int nestedCount;
    private boolean allowNull;

    MetadataVisitor() {
    }

    ThreadLocal<? extends MetadataVisitor<?>> creator() {
        return null;
    }

    final void setCurrentProperty(String string) {
        this.propertyPath[this.nestedCount - 1] = string;
    }

    List<String> getCurrentPropertyPath() {
        return UnmodifiableArrayList.wrap(this.propertyPath, 0, this.nestedCount);
    }

    /*
     * Unable to fully structure code
     */
    final R walk(MetadataStandard var1_1, Class<?> var2_2, Object var3_3, boolean var4_4) {
        if (!this.visited.containsKey(var3_3) && (var5_5 = var1_1.getAccessor(new CacheKey(var3_3.getClass(), var2_2), var4_4)) != null) {
            var6_6 = this.preVisit(var5_5);
            switch (1.$SwitchMap$org$apache$sis$metadata$MetadataVisitor$Filter[var6_6.ordinal()]) {
                case 1: {
                    return null;
                }
                case 2: {
                    var7_7 = true;
                    var8_8 = (ThreadLocal<MetadataVisitor<?>>)this.result();
                    break;
                }
                default: {
                    var7_7 = false;
                    var8_8 = null;
                }
            }
            if (this.visited.put(var3_3, var8_8) != null) {
                throw new ConcurrentModificationException();
            }
            if (this.nestedCount >= this.propertyPath.length) {
                this.propertyPath = Arrays.copyOf(this.propertyPath, this.nestedCount * 2);
            }
            if (this.nestedCount++ == 0) {
                this.allowNull = Semaphores.queryAndSet(1);
            }
            try {
                switch (1.$SwitchMap$org$apache$sis$metadata$MetadataVisitor$Filter[var6_6.ordinal()]) {
                    case 3: {
                        var5_5.walkReadable(this, var3_3);
                        ** break;
lbl24:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        var5_5.walkWritable(this, var3_3, var3_3);
                        ** break;
lbl28:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        var5_5.walkWritable(this, var3_3, var8_8);
                        break;
                    }
                    ** default:
lbl33:
                    // 1 sources

                    break;
                }
            }
            catch (MetadataVisitorException var9_10) {
                throw var9_10;
            }
            catch (Exception var9_11) {
                var9_12 = Exceptions.unwrap(var9_11);
                throw new MetadataVisitorException(Arrays.copyOf(this.propertyPath, this.nestedCount), var5_5.type, var9_12);
            }
            finally {
                if (--this.nestedCount == 0) {
                    Semaphores.clear(1, this.allowNull);
                    var11_14 = this.creator();
                    if (var11_14 != null) {
                        var11_14.remove();
                    }
                }
            }
            v0 = var9_9 = var7_7 != false ? var8_8 : (ThreadLocal<MetadataVisitor<?>>)this.result();
            if (this.visited.put(var3_3, var9_9) != var8_8) {
                throw new ConcurrentModificationException();
            }
            return (R)var9_9;
        }
        return this.visited.get(var3_3);
    }

    Filter preVisit(PropertyAccessor propertyAccessor) {
        return Filter.NON_EMPTY;
    }

    abstract Object visit(Class<?> var1, Object var2) throws Exception;

    R result() {
        return null;
    }

    static enum Filter {
        NONE,
        NON_EMPTY,
        WRITABLE,
        WRITABLE_RESULT;

    }
}

